/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.operationselector.jmsdefault.runtime;

import java.io.IOException;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSBytesXML;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSTextXML;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class OperationSelectorJMSDefaultServiceInterceptor
extends InterceptorAsyncImpl {
    private static final String ON_MESSAGE_METHOD_NAME = "onMessage";
    private Invoker next;
    private RuntimeEndpoint endpint;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentService service;
    private List<Operation> serviceOperations;
    private XMLHelper xmlHelper;

    public OperationSelectorJMSDefaultServiceInterceptor(ExtensionPointRegistry registry, JMSResourceFactory jmsResourceFactory, RuntimeEndpoint endpoint) {
        this.endpint = endpoint;
        this.jmsBinding = (JMSBinding)endpoint.getBinding();
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(registry, this.jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(registry, this.jmsBinding);
        this.service = (RuntimeComponentService)endpoint.getService();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
        this.xmlHelper = XMLHelperFactory.createXMLHelper(registry);
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        String operationName = this.requestMessageProcessor.getOperationName(jmsMsg);
        Operation operation = this.getTargetOperation(operationName, jmsMsg);
        msg.setOperation(operation);
        return msg;
    }

    protected Operation getTargetOperation(String operationName, javax.jms.Message jmsMsg) {
        Operation operation = null;
        if (this.serviceOperations.size() == 1) {
            operation = this.serviceOperations.get(0);
        } else if (operationName != null) {
            for (Operation op : this.serviceOperations) {
                if (op.getName().equals(operationName)) {
                    operation = op;
                } else {
                    String nativeName = this.jmsBinding.getNativeOperationName(op.getName());
                    if (nativeName == null || !nativeName.equals(operationName)) continue;
                    operation = op;
                }
                break;
            }
        } else if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault || this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSTextXML || this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSBytesXML) {
            block18: {
                try {
                    Object rootElement;
                    String operationFromPayload;
                    if (jmsMsg instanceof TextMessage) {
                        Object rootElement2;
                        String xmlPayload = ((TextMessage)jmsMsg).getText();
                        if (xmlPayload == null || (operationFromPayload = this.xmlHelper.getOperationName(rootElement2 = this.xmlHelper.load(xmlPayload))) == null) break block18;
                        for (Operation op : this.serviceOperations) {
                            if (!op.getName().equals(operationFromPayload)) continue;
                            operation = op;
                            break block18;
                        }
                        break block18;
                    }
                    if (!(jmsMsg instanceof BytesMessage)) break block18;
                    long noOfBytes = ((BytesMessage)jmsMsg).getBodyLength();
                    byte[] bytes = new byte[(int)noOfBytes];
                    ((BytesMessage)jmsMsg).readBytes(bytes);
                    ((BytesMessage)jmsMsg).reset();
                    if (bytes == null || (operationFromPayload = this.xmlHelper.getOperationName(rootElement = this.xmlHelper.load(new String(bytes)))) == null) break block18;
                    for (Operation op : this.serviceOperations) {
                        if (!op.getName().equals(operationFromPayload)) continue;
                        operation = op;
                        break;
                    }
                }
                catch (IOException e) {
                }
                catch (JMSException e) {
                    throw new JMSBindingException((Throwable)e);
                }
            }
            if (operation == null) {
                for (Operation op : this.serviceOperations) {
                    if (!op.getName().equals(ON_MESSAGE_METHOD_NAME)) continue;
                    operation = op;
                    break;
                }
            }
        }
        if (operation == null) {
            throw new JMSBindingException("Cannot determine service operation");
        }
        return operation;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return msg;
    }
}

