/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.host;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class JMSAsyncResponseInvoker
implements MessageListener {
    private static final Logger logger = Logger.getLogger(JMSAsyncResponseInvoker.class.getName());
    private RuntimeEndpointReference endpointReference;
    private JMSBinding jmsBinding;
    private JMSResourceFactory jmsResourceFactory;
    private RuntimeComponentReference reference;
    private MessageFactory messageFactory;

    public JMSAsyncResponseInvoker(RuntimeEndpointReference endpointReference, MessageFactory messageFactory, JMSResourceFactory rf) throws NamingException {
        this.endpointReference = endpointReference;
        this.jmsBinding = (JMSBinding)endpointReference.getBinding();
        this.jmsResourceFactory = rf;
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        this.messageFactory = messageFactory;
    }

    public void onMessage(javax.jms.Message requestJMSMsg) {
        logger.log(Level.FINE, "JMS reference '" + this.reference.getName() + "' received message " + requestJMSMsg);
        try {
            this.invokeReference(requestJMSMsg);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception send fault response '" + this.reference.getName(), e);
        }
    }

    protected void invokeReference(javax.jms.Message requestJMSMsg) throws JMSException, InvocationTargetException {
        Message tuscanyMsg = this.messageFactory.createMessage();
        JMSBindingContext context = new JMSBindingContext();
        tuscanyMsg.setBindingContext((Object)context);
        context.setJmsMsg(requestJMSMsg);
        context.setJmsResourceFactory(this.jmsResourceFactory);
        context.setReplyToDestination(requestJMSMsg.getJMSReplyTo());
        tuscanyMsg.setBody((Object)requestJMSMsg);
        this.endpointReference.invokeAsyncResponse(tuscanyMsg);
    }
}

