/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.headers;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class HeaderReferenceInterceptor
extends InterceptorAsyncImpl {
    private RuntimeEndpointReference runtimeWire;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private List<Operation> operations;

    public HeaderReferenceInterceptor(ExtensionPointRegistry extensions, JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeEndpointReference runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(extensions, jmsBinding);
        this.operations = runtimeWire.getReference().getInterfaceContract().getInterface().getOperations();
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message tuscanyMsg) {
        try {
            String callbackDestName;
            JMSBindingContext context = (JMSBindingContext)tuscanyMsg.getBindingContext();
            javax.jms.Message jmsMsg = (javax.jms.Message)tuscanyMsg.getBody();
            Operation operation = tuscanyMsg.getOperation();
            String operationName = operation.getName();
            RuntimeEndpointReference reference = this.runtimeWire;
            this.requestMessageProcessor.setOperationName(operationName, jmsMsg);
            if (this.jmsBinding.getEffectiveJMSDeliveryMode(operationName) != null) {
                if (this.jmsBinding.getEffectiveJMSDeliveryMode(operationName).booleanValue()) {
                    jmsMsg.setJMSDeliveryMode(2);
                } else {
                    jmsMsg.setJMSDeliveryMode(1);
                }
            }
            if (this.jmsBinding.getEffectiveJMSPriority(operationName) != null) {
                jmsMsg.setJMSPriority(this.jmsBinding.getEffectiveJMSPriority(operationName).intValue());
            }
            if (this.jmsBinding.getEffectiveJMSType(operationName) != null) {
                jmsMsg.setJMSType(this.jmsBinding.getEffectiveJMSType(operationName));
            }
            if (this.jmsBinding.getEffectiveJMSTimeToLive(operationName) != null) {
                jmsMsg.setJMSExpiration(this.jmsBinding.getEffectiveJMSTimeToLive(operationName).longValue());
            }
            if (this.jmsBinding.getOperationJMSCorrelationId(operationName) != null) {
                jmsMsg.setJMSCorrelationID(this.jmsBinding.getOperationJMSCorrelationId(operationName));
            } else if ("correlationID".equals(this.jmsBinding.getCorrelationScheme())) {
                jmsMsg.setJMSCorrelationID(UUID.randomUUID().toString());
            }
            if (tuscanyMsg.getFrom().getCallbackEndpoint() != null && (callbackDestName = this.getCallbackDestinationName(reference)) != null) {
                jmsMsg.setStringProperty("scaCallbackDestination", "jms:jndi:" + callbackDestName);
                if (operation.isNonBlocking()) {
                    Destination dest = context.getJmsResourceFactory().lookupDestination(callbackDestName);
                    jmsMsg.setJMSReplyTo(dest);
                }
            }
            for (String propName : this.jmsBinding.getPropertyNames()) {
                Object value = this.jmsBinding.getProperty(propName);
                jmsMsg.setObjectProperty(propName, value);
            }
            Map operationProperties = this.jmsBinding.getOperationProperties(operationName);
            if (operationProperties != null) {
                for (String propName : operationProperties.keySet()) {
                    Object value = operationProperties.get(propName);
                    jmsMsg.setObjectProperty(propName, value);
                }
            }
            if (this.jmsBinding.getEffectiveJMSTimeToLive(operationName) != null) {
                context.setTimeToLive(this.jmsBinding.getEffectiveJMSTimeToLive(operationName) * 2L);
            } else {
                context.setTimeToLive(20000L);
            }
            String msgID = (String)tuscanyMsg.getHeaders().get("MESSAGE_ID");
            if (msgID != null) {
                jmsMsg.setObjectProperty("MESSAGE_ID", (Object)msgID);
            }
            return tuscanyMsg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected String getCallbackDestinationName(RuntimeEndpointReference reference) {
        RuntimeEndpoint endpoint = (RuntimeEndpoint)reference.getCallbackEndpoint();
        if (endpoint != null) {
            JMSBindingServiceBindingProvider bp = (JMSBindingServiceBindingProvider)endpoint.getBindingProvider();
            return bp.getDestinationName();
        }
        return null;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        javax.jms.Message responseMsg = (javax.jms.Message)msg.getBody();
        try {
            String relatesTo;
            String operationName = responseMsg.getStringProperty("scaOperationName");
            for (Operation op : this.operations) {
                if (!operationName.equals(op.getName())) continue;
                msg.setOperation(op);
                break;
            }
            if ((relatesTo = responseMsg.getStringProperty("RELATES_TO")) != null) {
                msg.getHeaders().put("RELATES_TO", relatesTo);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return msg;
    }
}

