/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.context;

import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;

public class JMSBindingContext {
    private Message jmsMsg;
    private Session jmsSession;
    private Session jmsResponseSession;
    private Destination requestDestination;
    private Destination replyToDestination;
    private JMSResourceFactory jmsResourceFactory;
    private long timeToLive;
    private boolean useBytesForWFJMSDefaultResponse;
    private long requestTimeout;
    private Hashtable properties = new Hashtable();

    public Message getJmsMsg() {
        return this.jmsMsg;
    }

    public void setJmsMsg(Message jmsMsg) {
        this.jmsMsg = jmsMsg;
    }

    public synchronized Session getJmsSession() {
        if (this.jmsSession == null) {
            try {
                this.jmsSession = this.getJmsResourceFactory().createSession();
            }
            catch (Exception e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return this.jmsSession;
    }

    public synchronized void closeJmsSession() {
        if (this.jmsSession != null) {
            try {
                this.getJmsResourceFactory().closeSession(this.jmsSession);
            }
            catch (Exception e) {
                throw new JMSBindingException((Throwable)e);
            }
            finally {
                this.jmsSession = null;
            }
        }
    }

    public synchronized Session getJmsResponseSession() {
        if (this.jmsResponseSession == null) {
            try {
                this.jmsResponseSession = this.getJmsResourceFactory().createResponseSession();
            }
            catch (Exception e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return this.jmsResponseSession;
    }

    public synchronized void closeJmsResponseSession() {
        if (this.jmsResponseSession != null) {
            try {
                this.getJmsResourceFactory().closeResponseSession(this.jmsResponseSession);
            }
            catch (Exception e) {
                throw new JMSBindingException((Throwable)e);
            }
            finally {
                this.jmsResponseSession = null;
            }
        }
    }

    public Destination getRequestDestination() {
        return this.requestDestination;
    }

    public void setRequestDestination(Destination requestDestination) {
        this.requestDestination = requestDestination;
    }

    public Destination getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setReplyToDestination(Destination replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    public JMSResourceFactory getJmsResourceFactory() {
        return this.jmsResourceFactory;
    }

    public void setJmsResourceFactory(JMSResourceFactory jmsResourceFactory) {
        this.jmsResourceFactory = jmsResourceFactory;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public boolean isUseBytesForWFJMSDefaultResponse() {
        return this.useBytesForWFJMSDefaultResponse;
    }

    public void setUseBytesForWFJMSDefaultResponse(boolean useBytesForWFJMSDefaultResponse) {
        this.useBytesForWFJMSDefaultResponse = useBytesForWFJMSDefaultResponse;
    }

    public void setRequestTimeout(long l) {
        this.requestTimeout = l;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }
}

