/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import jline.Completor;
import jline.NullCompletor;
import org.apache.tuscany.sca.shell.Command;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.ServiceCompletor;
import org.apache.tuscany.sca.shell.jline.ServiceOperationCompletor;

public class Invoke
implements Command {
    private Shell shell;

    public Invoke(Shell shell) {
        this.shell = shell;
    }

    @Override
    public String getName() {
        return "invoke";
    }

    @Override
    public String getShortHelp() {
        return "invoke <component>[/<service>] <operation> [<arg0> <arg1> ...]";
    }

    @Override
    public String getHelp() {
        StringBuilder helpText = new StringBuilder();
        helpText.append("   Invokes an operation of a component service.\n");
        helpText.append("   (presently parameters are limited to simple types)\n");
        helpText.append("\n");
        helpText.append("   Arguments:\n");
        helpText.append("      component - (required) the name of the component\n");
        helpText.append("      service   - (optional) the name of the component service, which may be omitted\n");
        helpText.append("                             when the component has a single service.\n");
        helpText.append("      operation - (required) the name of the operation\n");
        helpText.append("      args      - (optional) the operation arguments\n");
        return helpText.toString();
    }

    @Override
    public Completor[] getCompletors() {
        return new Completor[]{new ServiceCompletor(this.shell), new ServiceOperationCompletor(this.shell), new NullCompletor()};
    }

    @Override
    public boolean invoke(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Wrong number of args");
            System.err.println(this.getShortHelp());
            return true;
        }
        String endpointName = args[0];
        String operationName = args[1];
        String[] params = new String[args.length - 2];
        System.arraycopy(args, 2, params, 0, params.length);
        Object proxy = this.shell.getNode().getService(null, endpointName);
        Invoke.invoke(proxy, operationName, params);
        return true;
    }

    static void invoke(Object proxy, String operationName, String ... params) throws IllegalAccessException, InvocationTargetException {
        Method foundMethod = null;
        for (Method m : proxy.getClass().getMethods()) {
            if (!m.getName().equals(operationName)) continue;
            if (m.getParameterTypes().length == params.length) {
                Object[] parameters = new Object[params.length];
                int i = 0;
                for (Class<?> type : m.getParameterTypes()) {
                    if (type == Byte.TYPE || type == Byte.class) {
                        parameters[i] = Byte.valueOf(params[i]);
                    } else if (type == Character.TYPE || type == Character.class) {
                        parameters[i] = Character.valueOf(params[i].charAt(0));
                    } else if (type == Boolean.TYPE || type == Boolean.class) {
                        parameters[i] = Boolean.valueOf(params[i]);
                    } else if (type == Short.TYPE || type == Short.class) {
                        parameters[i] = Short.valueOf(params[i]);
                    } else if (type == Integer.TYPE || type == Integer.class) {
                        parameters[i] = Integer.valueOf(params[i]);
                    } else if (type == Long.TYPE || type == Long.class) {
                        parameters[i] = Long.valueOf(params[i]);
                    } else if (type == Float.TYPE || type == Float.class) {
                        parameters[i] = Float.valueOf(params[i]);
                    } else if (type == Double.TYPE || type == Double.class) {
                        parameters[i] = Double.valueOf(params[i]);
                    } else if (type == String.class) {
                        parameters[i] = params[i];
                    } else {
                        throw new IllegalArgumentException("Parameter type is not supported: " + type);
                    }
                    ++i;
                }
                Object result = m.invoke(proxy, parameters);
                if (result != null && result.getClass().isArray()) {
                    System.out.println(Arrays.toString((Object[])result));
                } else {
                    System.out.println(result);
                }
                return;
            }
            foundMethod = m;
        }
        if (foundMethod != null) {
            System.err.println("Service operation " + foundMethod.getName() + " expects " + foundMethod.getParameterTypes().length + " arguments");
        } else {
            System.err.println("Operation not found: " + operationName);
        }
    }
}

