/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.TuscanyRuntime;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.xml.Utils;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.impl.NodeImpl;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.ContributionDescription;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.Version;
import org.apache.tuscany.sca.shell.Command;
import org.apache.tuscany.sca.shell.jline.JLine;

public class Shell {
    private boolean useJline;
    final List<String> history = new ArrayList<String>();
    private TuscanyRuntime runtime;
    private String currentDomain = "";
    private Map<String, Node> standaloneNodes = new HashMap<String, Node>();
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Map<String, Command> commands = new HashMap<String, Command>();
    public static final String[] COMMANDS = new String[]{"bye", "domain", "domains", "domainComposite", "help", "install", "installed", "load", "nodes", "remove", "run", "save", "services", "started"};

    public static void main(String[] args) throws Exception {
        Shell shell;
        boolean useJline = true;
        String domainURI = "uri:default";
        boolean showHelp = false;
        String contribution = null;
        String nodeXML = null;
        for (String s : args) {
            if ("-nojline".equals(s)) {
                useJline = false;
                continue;
            }
            if ("-help".equals(s)) {
                showHelp = true;
                continue;
            }
            if (s.startsWith("-nodeXML:")) {
                nodeXML = s.substring("-nodeXML:".length());
                continue;
            }
            if (s.startsWith("uri:") || s.startsWith("properties:")) {
                domainURI = s;
                continue;
            }
            contribution = s;
        }
        if (nodeXML != null) {
            shell = new Shell(new File(nodeXML), useJline);
        } else {
            shell = new Shell(domainURI, useJline);
            if (showHelp || contribution == null) {
                shell.help(null);
            }
            if (contribution != null) {
                System.out.println();
                System.out.println("install " + contribution + " -start");
                String curi = shell.getNode().installContribution(contribution);
                shell.getNode().startDeployables(curi);
            }
        }
        shell.run();
    }

    public Shell(File nodeXML, boolean useJLine) throws ContributionReadException, MalformedURLException, ActivationException, ValidationException {
        this.runtime = TuscanyRuntime.newInstance();
        this.useJline = useJLine;
        try {
            this.initCommands();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Node node = this.runtime.createNodeFromXML(nodeXML.toURI().toURL().toString());
        this.currentDomain = node.getDomainName();
        this.nodes.put(this.currentDomain, node);
    }

    public Shell(String domainURI, boolean useJLine) {
        this.runtime = TuscanyRuntime.newInstance();
        this.useJline = useJLine;
        try {
            this.initCommands();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (domainURI != null) {
            this.domain(domainURI);
        }
    }

    void initCommands() throws IOException {
        for (ServiceDeclaration sd : ServiceDiscovery.getInstance().getServiceDeclarations(Command.class)) {
            try {
                Class<?> c = Class.forName(sd.getClassName());
                try {
                    Command command = (Command)c.getConstructor(Shell.class).newInstance(this);
                    this.commands.put(command.getName(), command);
                }
                catch (NoSuchMethodException e) {
                    Command command = (Command)c.newInstance();
                    this.commands.put(command.getName(), command);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    boolean domain(String domainURI) {
        if (domainURI.length() < 1) {
            this.currentDomain = "";
        } else {
            for (Node node : this.nodes.values()) {
                if (!domainURI.equals(node.getDomainName())) continue;
                this.currentDomain = node.getDomainName();
                return true;
            }
            Node node = this.runtime.createNode(domainURI);
            this.currentDomain = node.getDomainName();
            this.nodes.put(this.currentDomain, node);
        }
        return true;
    }

    boolean domains() {
        for (Node node : this.nodes.values()) {
            System.out.println(node.getDomainName());
        }
        return true;
    }

    boolean domainComposite() {
        Composite domainComposite = this.getNode().getDomainComposite();
        System.out.println(Utils.modelToXML(domainComposite, true, this.runtime.getExtensionPointRegistry()));
        return true;
    }

    boolean install(List<String> toks) throws ContributionReadException, ActivationException, ValidationException {
        if (this.getNode() == null) {
            System.out.println("not in domain, use domain command first");
            return true;
        }
        String metaDataURL = null;
        if (toks.contains("-metadata")) {
            metaDataURL = toks.get(toks.indexOf("-metadata") + 1);
        }
        List<String> duris = null;
        if (toks.contains("-duris")) {
            duris = Arrays.asList(toks.get(toks.indexOf("-duris") + 1).split(","));
        }
        String first = null;
        String second = null;
        for (int i = 1; i < toks.size(); ++i) {
            if (toks.get(i).startsWith("-")) {
                if (toks.get(i).equals("-start")) continue;
                ++i;
                continue;
            }
            if (first == null) {
                first = toks.get(i);
                continue;
            }
            second = toks.get(i);
            break;
        }
        String curi = null;
        String curl = null;
        if (second != null) {
            curi = first;
            curl = second;
        } else {
            curl = first;
        }
        curl = this.mavenProject(curl);
        String uri = this.getNode().installContribution(curi, curl, metaDataURL, duris);
        System.out.println("installed at: " + uri);
        return true;
    }

    private String mavenProject(String curl) {
        File f = new File(curl);
        if (!f.exists()) {
            return curl;
        }
        if (!(f = new File(f, "target")).exists()) {
            return curl;
        }
        if ((f = new File(f, "classes")).exists()) {
            return f.toURI().toString();
        }
        return curl;
    }

    boolean installed(List<String> toks) throws ContributionReadException, ValidationException {
        if (this.getNode() == null) {
            return true;
        }
        if (toks.size() > 1) {
            String curi = toks.get(1);
            ContributionDescription cd = this.getNode().getInstalledContribution(toks.get(1));
            if (cd == null) {
                System.out.println("Contribution " + curi + " not installed");
            } else {
                System.out.println(curi);
                System.out.println("   URL: " + cd.getURL());
                ArrayList<String> ims = new ArrayList<String>();
                for (String im : cd.getJavaImports()) {
                    ims.add(im);
                }
                for (String im : cd.getNamespaceImports()) {
                    ims.add(im);
                }
                System.out.println("   Imports: " + ims);
                ArrayList<String> es = new ArrayList<String>();
                for (String e : cd.getJavaExports()) {
                    es.add(e);
                }
                for (String e : cd.getNamespaceExports()) {
                    es.add(e);
                }
                System.out.println("   Exports: " + es);
                ArrayList<String> ds = new ArrayList<String>();
                for (String cp : cd.getDeployables()) {
                    ds.add(cp);
                }
                for (String cp : cd.getAdditionalDeployables().keySet()) {
                    ds.add(cp);
                }
                System.out.println("   Deployables: " + ds);
            }
        } else {
            for (String curi : this.getNode().getInstalledContributionURIs()) {
                System.out.println("   " + curi);
            }
        }
        return true;
    }

    boolean listComposites(String curi) throws ContributionReadException, ValidationException {
        if (this.getNode() == null) {
            return true;
        }
        Contribution c = this.getNode().getContribution(curi);
        for (Artifact a : c.getArtifacts()) {
            if (!(a.getModel() instanceof Composite)) continue;
            System.out.println(((Composite)a.getModel()).getName());
        }
        return true;
    }

    boolean load(String configXmlUrl) throws ContributionReadException, ActivationException, ValidationException {
        Node node = this.runtime.createNodeFromXML(configXmlUrl);
        this.currentDomain = node.getDomainName();
        this.nodes.put(this.currentDomain, node);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean run(String commandsFileURL) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(IOHelper.getLocationAsURL(commandsFileURL).openStream()));
        try {
            String l;
            while ((l = r.readLine()) != null) {
                System.out.println(l);
                String[] toks = l != null ? l.trim().split(" ") : "".split(" ");
                List<String> toksList = this.getTokens(toks);
                this.apply(this.eval(toksList));
            }
        }
        finally {
            r.close();
        }
        return true;
    }

    boolean save(String directory) throws IOException {
        System.out.println("TODO: not yet implemented");
        return true;
    }

    boolean services() throws IOException {
        if (this.getNode() == null) {
            return true;
        }
        DomainRegistry reg = ((NodeImpl)this.getNode()).getEndpointRegistry();
        for (Endpoint endpoint : reg.getEndpoints()) {
            System.out.println(endpoint.getComponent().getURI() + "/" + endpoint.getService().getName());
            for (Binding b : endpoint.getService().getBindings()) {
                if (SCABinding.TYPE.equals(b.getType())) continue;
                System.out.println("    " + b.getType().getLocalPart() + " " + b.getURI());
            }
        }
        return true;
    }

    public boolean bye() {
        for (Node node : this.nodes.values()) {
            node.stop();
        }
        this.runtime.stop();
        for (Node node : this.standaloneNodes.values()) {
            node.stop();
        }
        return false;
    }

    boolean started(List<String> toks) {
        if (this.standaloneNodes.size() > 0) {
            System.out.println("Standalone Nodes:");
            for (String nodeName : this.standaloneNodes.keySet()) {
                Node node = this.standaloneNodes.get(nodeName);
                Map<String, List<String>> scs = node.getStartedCompositeURIs();
                for (String curi : scs.keySet()) {
                    for (String dc : scs.get(curi)) {
                        System.out.println("   " + nodeName + " " + dc);
                    }
                }
            }
            System.out.println();
        }
        if (this.nodes.size() > 0) {
            for (Node node : this.nodes.values()) {
                System.out.println("Domain: " + node.getDomainName());
                for (String curi : node.getStartedCompositeURIs().keySet()) {
                    for (String compositeURI : node.getStartedCompositeURIs().get(curi)) {
                        String runningNodeName = node.getRunningNodeName(curi, compositeURI);
                        if (node.getLocalNodeName().equals(runningNodeName)) {
                            runningNodeName = "this";
                        }
                        runningNodeName = "LocalOnly".equals(runningNodeName) ? "" : " (" + runningNodeName + ")";
                        System.out.println("   " + curi + " " + compositeURI + runningNodeName);
                    }
                }
            }
        }
        return true;
    }

    boolean nodes() {
        String localNode = this.getNode().getLocalNodeName();
        for (String node : this.getNode().getNodeNames()) {
            System.out.println(node + (localNode.equals(node) ? " (this)" : ""));
        }
        return true;
    }

    boolean status() {
        return true;
    }

    boolean history() {
        for (String l : this.history) {
            System.out.println(l);
        }
        return true;
    }

    public String[] getCommandNames() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.addAll(this.commands.keySet());
        cmds.addAll(Arrays.asList(COMMANDS));
        return cmds.toArray(new String[0]);
    }

    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public Node getNode() {
        return this.nodes.get(this.currentDomain);
    }

    List<String> read(Object r) throws IOException {
        String l;
        System.out.println();
        System.out.print(this.currentDomain + "> ");
        if (this.useJline) {
            l = JLine.readLine(r);
        } else {
            l = ((BufferedReader)r).readLine();
            this.history.add(l);
        }
        String[] toks = l != null ? l.trim().split(" ") : "bye".split(" ");
        return this.getTokens(toks);
    }

    List<String> getTokens(String[] toks) {
        ArrayList<String> toksList = new ArrayList<String>();
        for (int i = 0; i < toks.length; ++i) {
            if (toks[i] == null || toks[i].trim().length() <= 0) continue;
            int j = this.quotedString(toks, i);
            if (j > -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(toks[i]);
                for (int k = i + 1; k <= j; ++k) {
                    sb.append(" ");
                    sb.append(toks[k]);
                }
                i = j;
                String s = sb.toString();
                toksList.add(s.substring(1, s.length() - 1));
                continue;
            }
            toksList.add(toks[i]);
        }
        return toksList;
    }

    int quotedString(String[] toks, int i) {
        if (toks[i].startsWith("\"") || toks[i].startsWith("'")) {
            for (int j = i + 1; j < toks.length; ++j) {
                if (!toks[j].endsWith(toks[i].substring(0, 1))) continue;
                return j;
            }
        }
        return -1;
    }

    Callable<Boolean> eval(final List<String> toks) {
        String op;
        String string = op = toks.size() > 0 ? toks.get(0) : "";
        if (this.commands.keySet().contains(op)) {
            toks.remove(0);
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ((Command)Shell.this.commands.get(op)).invoke(toks.toArray(new String[0]));
                }
            };
        }
        if (op.equalsIgnoreCase("domain")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.domain(toks.size() > 1 ? (String)toks.get(1) : "");
                }
            };
        }
        if (op.equalsIgnoreCase("domains")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.domains();
                }
            };
        }
        if (op.equalsIgnoreCase("domainComposite")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.domainComposite();
                }
            };
        }
        if (op.equalsIgnoreCase("install")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.install(toks);
                }
            };
        }
        if (op.equalsIgnoreCase("installed")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.installed(toks);
                }
            };
        }
        if (op.equalsIgnoreCase("load")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.load((String)toks.get(1));
                }
            };
        }
        if (op.equalsIgnoreCase("nodes")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.nodes();
                }
            };
        }
        if (op.equalsIgnoreCase("run")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.run((String)toks.get(1));
                }
            };
        }
        if (op.equalsIgnoreCase("help")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return Shell.this.help(toks);
                }
            };
        }
        if (op.equalsIgnoreCase("save")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.save((String)toks.get(1));
                }
            };
        }
        if (op.equalsIgnoreCase("services")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.services();
                }
            };
        }
        if (op.equalsIgnoreCase("bye")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Shell.this.bye();
                }
            };
        }
        if (op.equalsIgnoreCase("started")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return Shell.this.started(toks);
                }
            };
        }
        if (op.equalsIgnoreCase("status")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return Shell.this.status();
                }
            };
        }
        if (op.equalsIgnoreCase("history")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return Shell.this.history();
                }
            };
        }
        if (op.equalsIgnoreCase("") || op.startsWith("#")) {
            return new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return true;
                }
            };
        }
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                System.out.println("unknown command");
                return true;
            }
        };
    }

    boolean apply(Callable<Boolean> func) {
        try {
            return func.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void run() throws IOException {
        Object reader = this.useJline ? JLine.createJLineReader(this) : new BufferedReader(new InputStreamReader(System.in));
        while (this.apply(this.eval(this.read(reader)))) {
        }
    }

    boolean help(List<String> toks) {
        String command;
        String string = command = toks == null || toks.size() < 2 ? null : toks.get(1);
        if (command == null) {
            this.helpOverview();
        } else if (this.commands.keySet().contains(command)) {
            System.out.println(this.commands.get(command).getShortHelp());
            System.out.println();
            System.out.println(this.commands.get(command).getHelp());
        } else if ("help".equalsIgnoreCase(command)) {
            this.helpHelp();
        } else if ("install".equalsIgnoreCase(command)) {
            this.helpInstall();
        } else if ("installed".equalsIgnoreCase(command)) {
            this.helpInstalled();
        } else if ("load".equalsIgnoreCase(command)) {
            this.helpLoad();
        } else if ("run".equalsIgnoreCase(command)) {
            this.helpRun();
        } else if ("save".equalsIgnoreCase(command)) {
            this.helpSave();
        } else if ("started".equalsIgnoreCase(command)) {
            this.helpStarted();
        } else if ("startup".equalsIgnoreCase(command)) {
            this.helpStartUp();
        } else if ("status".equalsIgnoreCase(command)) {
            this.helpStatus();
        } else if ("services".equalsIgnoreCase(command)) {
            this.helpServices();
        } else if ("bye".equalsIgnoreCase(command)) {
            this.helpBye();
        }
        return true;
    }

    boolean helpOverview() {
        System.out.println("Apache Tuscany Shell (" + Version.getVersion() + ")");
        System.out.println("Commands:");
        System.out.println();
        System.out.println("   help");
        for (Command command : this.commands.values()) {
            System.out.println("   " + command.getShortHelp());
        }
        System.out.println("   domain <domainURI>");
        System.out.println("   domains");
        System.out.println("   install [<uri>] <contributionURL> [-metadata <url>] [-duris <uri,uri,...>]");
        System.out.println("   installed [<contributionURI>]");
        System.out.println("   nodes");
        System.out.println("   run <commandsFileURL>");
        System.out.println("   save <directoryPath>");
        System.out.println("   services");
        System.out.println("   started");
        System.out.println("   status");
        System.out.println("   bye");
        System.out.println();
        if (this.useJline) {
            System.out.println("Use Tab key for command and argument completion");
        }
        System.out.println("For detailed help on each command do 'help <command>', for help of startup options do 'help startup'");
        return true;
    }

    void helpHelp() {
        System.out.println("   help [<command>]");
        System.out.println();
        System.out.println("   Outputs help on the Tuscany Shell");
        System.out.println("   If the command argument is used it provides detailed help on that command otherwise");
        System.out.println("   it provides an overview of available Shell commands");
        System.out.println();
        System.out.println("   To get help on starting the Tuscany Shell use 'help startup'");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      <command> - (optional) the command to get detailed help on");
    }

    void helpDomain() {
        System.out.println("   domain [<domainURI>]");
        System.out.println();
        System.out.println("   Starts or connects to a domain for the given domain URI.");
        System.out.println("   If no domain URI is specified switch to standalone mode.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      <domainURI> - (optional) the domain URI of the domain");
    }

    void helpDomains() {
        System.out.println("   domains");
        System.out.println();
        System.out.println("   Shows the currently defined domain URIs");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      none");
    }

    void helpInstall() {
        System.out.println("   install [<uri>] <contributionURL> [-start] [-metadata <url>] [-duris <uri,uri,...>]");
        System.out.println();
        System.out.println("   Creates an installed contribution with a supplied root contribution, installed at abase URI.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      uri - (optional) the URI (name) to use for the contribution. When no uri is specified");
        System.out.println("               a default URI is used derived from the contribution URL");
        System.out.println("      contributionURL - (required) the URL to the contribution to install");
        System.out.println("      -start - (optional) start any composites listed as deployable in the sca-contribution.xml file");
        System.out.println("      -metadata <url> - (optional) the URL to an external contribution meta data document that should be");
        System.out.println("               merged into any existing sca-contributions.xml file within the contribution.");
        System.out.println("      -duris <uri,uri,...> - (optional) specifies the URIs of contributions that are used to resolve the");
        System.out.println("               dependencies of the root contribution and other dependent contributions.");
        System.out.println("               When not specified all installed contributions are used to resolve dependencies.");
    }

    void helpInstalled() {
        System.out.println("   installed [<contributionURI>]");
        System.out.println();
        System.out.println("   Shows information about the contributions installed on this node,");
        System.out.println("   including the contribution URI and location along with the URI");
        System.out.println("   and QName of any composites within the contribution");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      contributionURI - (optional) the URI of an installed contribution");
    }

    void helpLoad() {
        System.out.println("   load <configXmlUrl>");
        System.out.println();
        System.out.println("   Shows information about the contributions installed on this node,");
        System.out.println("   including the contribution URI and location along with the URI");
        System.out.println("   and QName of any composites within the contribution");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      configXmlUrl - (required) the URL of the config file to load");
    }

    void helpRemove() {
        System.out.println("   remove <contributionURI>");
        System.out.println();
        System.out.println("   Removes an installed contribution");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      contributionURI - (required) the URI of an installed contribution");
    }

    void helpRun() {
        System.out.println("   run <commandsFileURL>");
        System.out.println();
        System.out.println("   Runs shell commands stored in file.");
        System.out.println("   The file should be a text file with one shell command per line. Blank lines and ");
        System.out.println("   lines starting with # will be ignored.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      commandsFileURL - (required) the URL of the commands file to run");
    }

    void helpSave() {
        System.out.println("   save <directoryPath>");
        System.out.println();
        System.out.println("   Saves the current Node state to directory.");
        System.out.println("   This will include a node-config.xml file and copies of all artifacts");
        System.out.println("   being used by the Node.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      directoryPath - (required) the URL of a directory to be used to store the state.");
    }

    void helpServices() {
        System.out.println("   services");
        System.out.println();
        System.out.println("   Lists the components and services available in the Domain.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      none");
    }

    void helpStarted() {
        System.out.println("   started [<curi> [<compositeUri>]]");
        System.out.println();
        System.out.println("   Shows the status of the Node, listing for each started composite, its");
        System.out.println("   contribution URI, the composite URI, and the composite QName.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      curi - (optional) the URI of an installed contribution");
        System.out.println("      compositeUri - (optional) the URI of a composite");
    }

    void helpStatus() {
        System.out.println("   status");
        System.out.println();
        System.out.println("   Shows the status of the Shell including information on the known domains,");
        System.out.println("   installed contributions, and started composites");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      none");
    }

    void helpBye() {
        System.out.println("   bye");
        System.out.println();
        System.out.println("   All deployed composites are stopped and the Shell exists.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      none");
    }

    void helpStartUp() {
        System.out.println("   Tuscany Shell StartUp Options ");
        System.out.println();
        System.out.println("   When starting the Tuscany Shell there are optional arguments that can configure the Shell.");
        System.out.println();
        System.out.println("   Arguments:");
        System.out.println("      <domainURI> (optional) the URI of the domain.");
        System.out.println("                  When the domainURI is a simple string then the Shell starts a standalone");
        System.out.println("                  Node using the string as the domain name or 'default' if no name is specified.");
        System.out.println("                  When the domainURI starts with 'uri:' the Shell starts a distributed Node ");
        System.out.println("                  and the URI can encode parameters to configure the domain as follows:");
        System.out.println("                  uri:<domainName?key1=value1&key2=value2&...");
        System.out.println("                  The keys are optional and some keys are:");
        System.out.println("                  bind=ip[:port] - defines the local bind address and port, if the port is not specified it");
        System.out.println("                      defaults 14820 and if that port in use it will try incrementing by one till a free port is found.");
        System.out.println("                  multicast=groupip:port | off - defines if multicast discovery is used and if so what multicast IP group and port is used.");
        System.out.println("                      It defaults to 224.5.12.10:51482. A value of 'off' means multicast is disabled.");
        System.out.println("                  wka=ip[:port] - a comma separated list of ip address and port for remote nodes in");
        System.out.println("                                  the domain group when multicast is not available. The port defaults to 14820.");
        System.out.println("                  userid= is the userid other nodes must use to connect to this domain group. The default is the default domain name.");
        System.out.println("                  password= is the password other nodes must use to connect to this domain group. The default is 'tuscany'.");
        System.out.println();
        System.out.println("      -nojline    (optional) use plain Java System.in/out instead of JLine");
        System.out.println("                             (no tab completion or advanced line editing will be available)");
    }
}

