/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyContainer;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public abstract class BasePolicyProvider<T>
implements PolicyProvider {
    protected Class<T> policyType;
    protected PolicySubject subject;

    protected BasePolicyProvider(Class<T> policyType, PolicySubject subject) {
        this.policyType = policyType;
        this.subject = subject;
    }

    protected List<T> findPoliciesWithProvidedIntents(List<Intent> intents) {
        ArrayList<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
        List<PolicySet> policySets = this.subject.getPolicySets();
        for (PolicySet ps : policySets) {
            List<Intent> provided = ps.getProvidedIntents();
            for (Intent intent : intents) {
                if (!provided.contains(intent)) continue;
                applicablePolicySets.add(ps);
            }
        }
        return this.findPolicies(applicablePolicySets);
    }

    protected List<T> findPolicies() {
        return this.findPolicies(this.subject.getPolicySets());
    }

    protected List<T> findPolicies(Operation operation) {
        ArrayList<PolicySet> policySets = new ArrayList<PolicySet>();
        policySets.addAll(this.subject.getPolicySets());
        policySets.addAll(operation.getPolicySets());
        if (this.subject instanceof Endpoint) {
            for (Operation op : ((Endpoint)this.subject).getComponent().getImplementation().getOperations()) {
                if (!op.getName().equals(operation.getName())) continue;
                policySets.addAll(op.getPolicySets());
                break;
            }
        }
        return this.findPolicies(policySets);
    }

    private List<T> findPolicies(List<PolicySet> policySets) {
        ArrayList<T> policies = new ArrayList<T>();
        for (PolicySet ps : policySets) {
            for (PolicyExpression p : ps.getPolicies()) {
                Object policy;
                if (this.policyType.isInstance(p)) {
                    policies.add(this.policyType.cast(p));
                }
                if (!(p instanceof PolicyExpression)) continue;
                PolicyExpression exp = p;
                if (this.policyType.isInstance(exp.getPolicy())) {
                    policies.add(this.policyType.cast(exp.getPolicy()));
                }
                if (!PolicyContainer.class.isInstance(exp.getPolicy()) || (policy = ((PolicyContainer)exp.getPolicy()).getChildPolicy(this.policyType)) == null) continue;
                policies.add(this.policyType.cast(policy));
            }
        }
        return policies;
    }

    protected List<PolicySet> findPolicySets() {
        ArrayList<PolicySet> policies = new ArrayList<PolicySet>();
        List<PolicySet> policySets = this.subject.getPolicySets();
        for (PolicySet ps : policySets) {
            for (PolicyExpression p : ps.getPolicies()) {
                PolicyExpression exp;
                if (this.policyType.isInstance(p)) {
                    policies.add(ps);
                }
                if (!(p instanceof PolicyExpression) || !this.policyType.isInstance((exp = p).getPolicy())) continue;
                policies.add(ps);
            }
        }
        return policies;
    }

    protected PolicySet findPolicySet() {
        List<PolicySet> policySets = this.subject.getPolicySets();
        for (PolicySet ps : policySets) {
            for (PolicyExpression p : ps.getPolicies()) {
                PolicyExpression exp;
                if (this.policyType.isInstance(p)) {
                    return ps;
                }
                if (!(p instanceof PolicyExpression) || !this.policyType.isInstance((exp = p).getPolicy())) continue;
                return ps;
            }
        }
        return null;
    }

    protected String getContext() {
        if (this.subject instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)this.subject;
            return endpoint.getURI();
        }
        if (this.subject instanceof EndpointReference) {
            EndpointReference endpointReference = (EndpointReference)this.subject;
            return endpointReference.getURI();
        }
        if (this.subject instanceof Component) {
            Component component = (Component)this.subject;
            return component.getURI();
        }
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public PhasedInterceptor createInterceptor(Operation operation) {
        return null;
    }

    @Override
    public PhasedInterceptor createBindingInterceptor() {
        return null;
    }

    @Override
    public void configureBinding(Object configuration) {
    }

    protected InvocationChain getInvocationChain() {
        block6: {
            block7: {
                block5: {
                    if (!(this.subject instanceof RuntimeEndpoint)) break block5;
                    RuntimeEndpoint endpoint = (RuntimeEndpoint)this.subject;
                    List<InvocationChain> chains = endpoint.getInvocationChains();
                    for (InvocationChain chain : chains) {
                        this.configure(chain, chain.getTargetOperation());
                    }
                    break block6;
                }
                if (!(this.subject instanceof RuntimeEndpointReference)) break block7;
                RuntimeEndpointReference endpointReference = (RuntimeEndpointReference)this.subject;
                List<InvocationChain> chains = endpointReference.getInvocationChains();
                for (InvocationChain chain : chains) {
                    this.configure(chain, chain.getSourceOperation());
                }
                break block6;
            }
            if (!(this.subject instanceof RuntimeComponent)) break block6;
            RuntimeComponent component = (RuntimeComponent)this.subject;
            for (ComponentService s : component.getServices()) {
                RuntimeComponentService service = (RuntimeComponentService)s;
                for (Endpoint ep : service.getEndpoints()) {
                    List<InvocationChain> chains = ((RuntimeEndpoint)ep).getInvocationChains();
                    for (InvocationChain chain : chains) {
                        this.configure(chain, chain.getTargetOperation());
                    }
                }
            }
        }
        return null;
    }

    protected void configure(InvocationChain invocationChain, Operation operation) {
    }
}

