/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;

public class IntentProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<Intent>,
PolicyConstants {
    private PolicyFactory policyFactory;

    public IntentProcessor(FactoryExtensionPoint modelFactories) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
    }

    public IntentProcessor(PolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void warn(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public Intent read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Intent intent = null;
        String intentLocalName = reader.getAttributeValue(null, "name");
        if (intentLocalName == null) {
            this.error(context.getMonitor(), "IntentNameMissing", reader, new Object[0]);
            return null;
        }
        String intentType = reader.getAttributeValue(null, "intentType");
        if (intentType == null) {
            intentType = Intent.Type.interaction.name();
        }
        intent = this.policyFactory.createIntent();
        intent.setName(new QName(intentLocalName));
        intent.setType(Intent.Type.valueOf(intentType));
        this.readRequiredIntents(intent, reader, context);
        this.readExcludedIntents(intent, reader);
        this.readConstrainedTypes(intent, reader);
        String mutuallyExclusiveString = reader.getAttributeValue(null, "mutuallyExclusive");
        if (mutuallyExclusiveString != null && mutuallyExclusiveString.equals("true")) {
            intent.setMutuallyExclusive(true);
        } else {
            intent.setMutuallyExclusive(false);
        }
        Intent current = intent;
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (DESCRIPTION_QNAME.equals(name)) {
                        String text = reader.getElementText();
                        if (text != null) {
                            text = text.trim();
                        }
                        current.setDescription(text);
                        break;
                    }
                    if (!INTENT_QUALIFIER_QNAME.equals(name)) break;
                    String qualifierName = reader.getAttributeValue(null, "name");
                    String defaultQ = reader.getAttributeValue(null, "default");
                    boolean isDefault = defaultQ == null ? false : Boolean.parseBoolean(defaultQ);
                    String qualifiedIntentName = intentLocalName + "." + qualifierName;
                    Intent qualified = this.policyFactory.createIntent();
                    qualified.setUnresolved(false);
                    qualified.setType(intent.getType());
                    qualified.setName(new QName(qualifiedIntentName));
                    if (isDefault) {
                        if (intent.getDefaultQualifiedIntent() == null) {
                            intent.setDefaultQualifiedIntent(qualified);
                        } else {
                            Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", "MultipleDefaultQualifiers", intent.getName().toString());
                        }
                    }
                    if (!intent.getQualifiedIntents().contains(qualified)) {
                        intent.getQualifiedIntents().add(qualified);
                    } else {
                        Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", "QualifierIsNotUnique", intent.getName().toString(), qualifierName);
                    }
                    qualified.setQualifiableIntent(intent);
                    current = qualified;
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (!INTENT_QUALIFIER_QNAME.equals(name)) break;
                    current = intent;
                }
            }
            if (event == 2 && POLICY_INTENT_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        if (intent.getQualifiedIntents().size() == 1) {
            intent.setDefaultQualifiedIntent(intent.getQualifiedIntents().get(0));
        }
        if (intent.isMutuallyExclusive()) {
            for (Intent qualifiedIntent : intent.getQualifiedIntents()) {
                for (Intent excludedIntent : intent.getQualifiedIntents()) {
                    if (qualifiedIntent == excludedIntent) continue;
                    qualifiedIntent.getExcludedIntents().add(excludedIntent);
                }
            }
        }
        return intent;
    }

    @Override
    public void write(Intent intent, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        StringBuffer sb;
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "intent");
        writer.writeNamespace(intent.getName().getPrefix(), intent.getName().getNamespaceURI());
        writer.writeAttribute("name", intent.getName().getPrefix() + ":" + intent.getName().getLocalPart());
        if (intent.getRequiredIntents() != null && intent.getRequiredIntents().size() > 0) {
            sb = new StringBuffer();
            for (Intent requiredIntents : intent.getRequiredIntents()) {
                sb.append(requiredIntents.getName());
                sb.append(" ");
            }
            writer.writeAttribute("requires", sb.toString());
        }
        if (intent.getExcludedIntents() != null && intent.getExcludedIntents().size() > 0) {
            sb = new StringBuffer();
            for (Intent excludedIntents : intent.getExcludedIntents()) {
                sb.append(excludedIntents.getName());
                sb.append(" ");
            }
            writer.writeAttribute("excludes", sb.toString());
        }
        if (intent.getConstrainedTypes() != null && intent.getConstrainedTypes().size() > 0) {
            sb = new StringBuffer();
            for (ExtensionType contrainedArtifact : intent.getConstrainedTypes()) {
                sb.append(contrainedArtifact.getType().getPrefix());
                sb.append(':').append(contrainedArtifact.getType().getLocalPart());
                sb.append(" ");
            }
            writer.writeAttribute("constrains", sb.toString());
        }
        if (intent.getDescription() != null && intent.getDescription().length() > 0) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "description");
            writer.writeCData(intent.getDescription());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void resolveContrainedTypes(Intent intent, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        HashSet<ExtensionType> resolvedTypes = new HashSet<ExtensionType>();
        for (ExtensionType extensionType : intent.getConstrainedTypes()) {
            if (ExtensionType.BINDING_BASE.equals(extensionType.getType()) || ExtensionType.IMPLEMENTATION_BASE.equals(extensionType.getType())) {
                extensionType.setUnresolved(false);
                resolvedTypes.add(extensionType);
                continue;
            }
            ExtensionType resolved = resolver.resolveModel(ExtensionType.class, extensionType, context);
            if (!resolved.isUnresolved() || resolved != extensionType) {
                resolvedTypes.add(resolved);
                continue;
            }
            this.warn(context.getMonitor(), "ConstrainedTypeNotFound", intent, extensionType, intent);
        }
        intent.getConstrainedTypes().clear();
        intent.getConstrainedTypes().addAll(resolvedTypes);
    }

    private void resolveProfileIntent(Intent intent, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Monitor monitor = context.getMonitor();
        if (intent != null && !intent.getRequiredIntents().isEmpty()) {
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
            for (Intent required : intent.getRequiredIntents()) {
                if (required.isUnresolved()) {
                    Intent resolved = resolver.resolveModel(Intent.class, required, context);
                    if (resolved.isUnresolved() && resolved.getRequiredIntents().contains(intent)) {
                        this.error(monitor, "CyclicReferenceFound", resolver, required, intent);
                        return;
                    }
                    if (!resolved.isUnresolved() || resolved != required) {
                        requiredIntents.add(resolved);
                        continue;
                    }
                    this.error(monitor, "RequiredIntentNotFound", resolver, required, intent);
                    return;
                }
                requiredIntents.add(required);
            }
            intent.getRequiredIntents().clear();
            intent.getRequiredIntents().addAll(requiredIntents);
        }
    }

    private void resolveQualifiedIntent(Intent qualifed, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (qualifed != null) {
            Intent parent = qualifed.getQualifiableIntent();
            if (parent == null) {
                return;
            }
            if (parent.isUnresolved()) {
                Intent resolved = resolver.resolveModel(Intent.class, parent, context);
                if (!resolved.isUnresolved() || resolved != qualifed) {
                    qualifed.setQualifiableIntent(resolved);
                } else {
                    this.error(context.getMonitor(), "QualifiableIntentNotFound", resolver, parent, qualifed);
                }
            }
        }
    }

    @Override
    public void resolve(Intent intent, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (intent != null && intent.isUnresolved()) {
            this.resolveProfileIntent(intent, resolver, context);
            this.resolveExcludedIntents(intent, resolver, context);
            this.resolveQualifiedIntent(intent, resolver, context);
            this.resolveContrainedTypes(intent, resolver, context);
            intent.setUnresolved(false);
        }
    }

    @Override
    public QName getArtifactType() {
        return POLICY_INTENT_QNAME;
    }

    private void readConstrainedTypes(Intent policyIntent, XMLStreamReader reader) throws ContributionReadException {
        String value = reader.getAttributeValue(null, "constrains");
        if (value != null) {
            List<ExtensionType> constrainedTypes = policyIntent.getConstrainedTypes();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                ExtensionType extensionType = this.policyFactory.createExtensionType();
                extensionType.setType(qname);
                constrainedTypes.add(extensionType);
            }
        }
    }

    private void readRequiredIntents(Intent intent, XMLStreamReader reader, ProcessorContext context) {
        String value = reader.getAttributeValue(null, "requires");
        if (value != null) {
            List<Intent> requiredIntents = intent.getRequiredIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent required = this.policyFactory.createIntent();
                required.setName(qname);
                required.setUnresolved(true);
                requiredIntents.add(required);
            }
            if (requiredIntents.size() > 0 && intent.getName().getLocalPart().contains(".")) {
                Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", "ProfileIntentNameWithPeriod", intent.getName().toString());
            }
        }
    }

    private void readExcludedIntents(Intent intent, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "excludes");
        if (value != null) {
            List<Intent> excludedIntents = intent.getExcludedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent excluded = this.policyFactory.createIntent();
                excluded.setName(qname);
                excluded.setUnresolved(true);
                excludedIntents.add(excluded);
            }
        }
    }

    private void resolveExcludedIntents(Intent policyIntent, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (policyIntent != null) {
            ArrayList<Intent> excludedIntents = new ArrayList<Intent>();
            for (Intent excludedIntent : policyIntent.getExcludedIntents()) {
                if (excludedIntent.isUnresolved()) {
                    Intent resolvedExcludedIntent = resolver.resolveModel(Intent.class, excludedIntent, context);
                    if (!resolvedExcludedIntent.isUnresolved() || resolvedExcludedIntent != excludedIntent) {
                        excludedIntents.add(resolvedExcludedIntent);
                        continue;
                    }
                    this.error(context.getMonitor(), "ExcludedIntentNotFound", resolver, excludedIntent, policyIntent);
                    return;
                }
                excludedIntents.add(excludedIntent);
            }
            policyIntent.getExcludedIntents().clear();
            policyIntent.getExcludedIntents().addAll(excludedIntents);
        }
    }

    @Override
    public Class<Intent> getModelType() {
        return Intent.class;
    }
}

