/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;

abstract class ExtensionTypeProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<ExtensionType>,
PolicyConstants {
    private PolicyFactory policyFactory;

    protected abstract ExtensionType resolveExtensionType(ExtensionType var1, ModelResolver var2, ProcessorContext var3) throws ContributionResolveException;

    public ExtensionTypeProcessor(PolicyFactory policyFactory, StAXArtifactProcessor<Object> extensionProcessor) {
        this.policyFactory = policyFactory;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public ExtensionType read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        QName extType = this.getArtifactType();
        QName type = this.getQName(reader, "type");
        if (type != null) {
            ExtensionType extensionType = null;
            if (BINDING_TYPE_QNAME.equals(extType)) {
                extensionType = this.policyFactory.createBindingType();
            } else if (IMPLEMENTATION_TYPE_QNAME.equals(extType)) {
                extensionType = this.policyFactory.createImplementationType();
            } else {
                this.error(context.getMonitor(), "UnrecognizedExtensionType", reader, type);
                return null;
            }
            extensionType.setType(type);
            extensionType.setUnresolved(true);
            this.readAlwaysProvidedIntents(extensionType, reader);
            this.readMayProvideIntents(extensionType, reader);
            return extensionType;
        }
        this.error(context.getMonitor(), "RequiredAttributeMissing", reader, extType);
        return null;
    }

    private void readAlwaysProvidedIntents(ExtensionType extnType, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "alwaysProvides");
        if (value != null) {
            List<Intent> alwaysProvided = extnType.getAlwaysProvidedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                alwaysProvided.add(intent);
            }
        }
    }

    private void readMayProvideIntents(ExtensionType extnType, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "mayProvide");
        if (value != null) {
            List<Intent> mayProvide = extnType.getMayProvidedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                mayProvide.add(intent);
            }
        }
    }

    @Override
    public void write(ExtensionType extnType, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        if (extnType instanceof BindingType) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "bindingType");
        } else if (extnType instanceof ImplementationType) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementationType");
        }
        this.writeAlwaysProvidesIntentsAttribute(extnType, writer);
        this.writeMayProvideIntentsAttribute(extnType, writer);
        writer.writeEndElement();
    }

    private void writeMayProvideIntentsAttribute(ExtensionType extnType, XMLStreamWriter writer) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        for (Intent intent : extnType.getMayProvidedIntents()) {
            writer.writeNamespace(intent.getName().getPrefix(), intent.getName().getNamespaceURI());
            sb.append(intent.getName().getPrefix() + ":" + intent.getName().getLocalPart());
            sb.append(" ");
        }
        if (sb.length() > 0) {
            writer.writeAttribute("mayProvide", sb.toString());
        }
    }

    private void writeAlwaysProvidesIntentsAttribute(ExtensionType extnType, XMLStreamWriter writer) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        for (Intent intent : extnType.getAlwaysProvidedIntents()) {
            writer.writeNamespace(intent.getName().getPrefix(), intent.getName().getNamespaceURI());
            sb.append(intent.getName().getPrefix() + ":" + intent.getName().getLocalPart());
            sb.append(" ");
        }
        if (sb.length() > 0) {
            writer.writeAttribute("alwaysProvides", sb.toString());
        }
    }

    @Override
    public void resolve(ExtensionType extnType, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (extnType != null && extnType.isUnresolved()) {
            this.resolveAlwaysProvidedIntents(extnType, resolver, context);
            this.resolveMayProvideIntents(extnType, resolver, context);
            extnType.setUnresolved(false);
        }
    }

    private void resolveAlwaysProvidedIntents(ExtensionType extensionType, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (extensionType != null) {
            ArrayList<Intent> alwaysProvided = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getAlwaysProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    if (!(providedIntent = resolver.resolveModel(Intent.class, providedIntent, context)).isUnresolved()) {
                        alwaysProvided.add(providedIntent);
                        continue;
                    }
                    this.error(context.getMonitor(), "AlwaysProvidedIntentNotFound", resolver, providedIntent, extensionType);
                    continue;
                }
                alwaysProvided.add(providedIntent);
            }
            extensionType.getAlwaysProvidedIntents().clear();
            extensionType.getAlwaysProvidedIntents().addAll(alwaysProvided);
        }
    }

    private void resolveMayProvideIntents(ExtensionType extensionType, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (extensionType != null) {
            ArrayList<Intent> mayProvide = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getMayProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    if (!(providedIntent = resolver.resolveModel(Intent.class, providedIntent, context)).isUnresolved()) {
                        mayProvide.add(providedIntent);
                        continue;
                    }
                    this.error(context.getMonitor(), "MayProvideIntentNotFound", resolver, providedIntent, extensionType);
                    continue;
                }
                mayProvide.add(providedIntent);
            }
            extensionType.getMayProvidedIntents().clear();
            extensionType.getMayProvidedIntents().addAll(mayProvide);
        }
    }

    @Override
    public Class<ExtensionType> getModelType() {
        return ExtensionType.class;
    }
}

