/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http.ssl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.security.http.ssl.HTTPSPolicy;

public class HTTPSPolicyProcessor
implements StAXArtifactProcessor<HTTPSPolicy> {
    private static final QName KEY_STORE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "keyStore");
    private static final QName TRUST_STORE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "trustStore");

    public HTTPSPolicyProcessor(FactoryExtensionPoint modelFactories) {
    }

    @Override
    public QName getArtifactType() {
        return HTTPSPolicy.NAME;
    }

    @Override
    public Class<HTTPSPolicy> getModelType() {
        return HTTPSPolicy.class;
    }

    @Override
    public HTTPSPolicy read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        HTTPSPolicy policy = new HTTPSPolicy();
        int event = reader.getEventType();
        QName start = reader.getName();
        QName name = null;
        while (true) {
            switch (event) {
                case 1: {
                    String password;
                    String file;
                    String type;
                    name = reader.getName();
                    if (KEY_STORE_QNAME.equals(name)) {
                        type = reader.getAttributeValue(null, "type");
                        if (type == null) {
                            Monitor.error(context.getMonitor(), (Object)this, "policy-security-validation-messages", "RequiredAttributeKeyStoreTypeMissing", new Object[0]);
                        } else {
                            policy.setKeyStoreType(type);
                        }
                        file = reader.getAttributeValue(null, "file");
                        if (file == null) {
                            Monitor.error(context.getMonitor(), (Object)this, "policy-security-validation-messages", "RequiredAttributeKeyStoreFileMissing", new Object[0]);
                        } else {
                            policy.setKeyStore(file);
                        }
                        password = reader.getAttributeValue(null, "password");
                        if (file == null) {
                            Monitor.error(context.getMonitor(), (Object)this, "policy-security-validation-messages", "RequiredAttributeKeyStorePasswordMissing", new Object[0]);
                            break;
                        }
                        policy.setKeyStorePassword(password);
                        break;
                    }
                    if (!TRUST_STORE_QNAME.equals(name)) break;
                    type = reader.getAttributeValue(null, "type");
                    if (type == null) {
                        Monitor.error(context.getMonitor(), (Object)this, "policy-security-validation-messages", "RequiredAttributeTrustStoreTypeMissing", new Object[0]);
                    } else {
                        policy.setTrustStoreType(type);
                    }
                    file = reader.getAttributeValue(null, "file");
                    if (file == null) {
                        Monitor.error(context.getMonitor(), (Object)this, "policy-security-validation-messages", "RequiredAttributeTrustStoreFileMissing", new Object[0]);
                    } else {
                        policy.setTrustStore(file);
                    }
                    password = reader.getAttributeValue(null, "password");
                    if (file == null) {
                        Monitor.error(context.getMonitor(), (Object)this, "policy-security-validation-messages", "RequiredAttributeTrustStorePasswordMissing", new Object[0]);
                        break;
                    }
                    policy.setTrustStorePassword(password);
                    break;
                }
                case 2: {
                    if (!start.equals(reader.getName())) break;
                    if (reader.hasNext()) {
                        reader.next();
                    }
                    return policy;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return policy;
    }

    @Override
    public void write(HTTPSPolicy model, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
    }

    @Override
    public void resolve(HTTPSPolicy model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

