/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.management;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.impl.NodeImpl;
import org.apache.tuscany.sca.node.management.NodeManagerMBean;

public class NodeManager
implements NodeManagerMBean {
    private NodeImpl node;
    private ObjectName name;

    public NodeManager(NodeImpl node) {
        this.node = node;
        try {
            this.name = NodeManager.getName(node);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    @Override
    public String getURI() {
        return this.node.getURI();
    }

    @Override
    public String getDomainURI() {
        return this.node.getConfiguration().getDomainURI();
    }

    public ObjectName getName() {
        return this.name;
    }

    private static ObjectName getName(NodeImpl node) throws MalformedObjectNameException {
        String name = Node.class.getPackage().getName() + ":type=" + Node.class.getSimpleName() + ",uri=" + ObjectName.quote(node.getURI());
        return ObjectName.getInstance(name);
    }
}

