/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.impl;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLObjectImpl;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;

public class WSDLDefinitionImpl
implements WSDLDefinition {
    private Definition definition;
    private String namespace;
    private URI location;
    private URI uri;
    private List<WSDLDefinition> imported = new ArrayList<WSDLDefinition>();
    private List<XSDefinition> schemas = new ArrayList<XSDefinition>();
    private boolean unresolved;
    private Binding binding;
    private QName nameOfPortTypeToResolve;
    private QName nameOfBindingToResolve;
    private QName nameOfServiceToResolve;
    private Map<String, String> wsdliLocations = new HashMap<String, String>();

    protected WSDLDefinitionImpl() {
    }

    @Override
    public Definition getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public String getNamespace() {
        if (this.isUnresolved()) {
            return this.namespace;
        }
        if (this.definition != null) {
            return this.definition.getTargetNamespace();
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.namespace = namespace;
    }

    @Override
    public List<XSDefinition> getXmlSchemas() {
        return this.schemas;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI url) {
        this.location = url;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
    }

    @Override
    public List<WSDLDefinition> getImportedDefinitions() {
        return this.imported;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WSDLDefinitionImpl)) {
            return false;
        }
        WSDLDefinitionImpl other = (WSDLDefinitionImpl)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    @Override
    public XmlSchemaElement getXmlSchemaElement(QName name) {
        XmlSchemaElement element;
        XmlSchemaElement element2;
        XmlSchemaCollection schemaCollection = null;
        for (XSDefinition xsd : this.schemas) {
            if (schemaCollection == null && xsd.getSchemaCollection() != null) {
                schemaCollection = xsd.getSchemaCollection();
            }
            if ((element2 = xsd.getXmlSchemaElement(name)) == null) continue;
            return element2;
        }
        if (schemaCollection != null && (element = schemaCollection.getElementByQName(name)) != null) {
            return element;
        }
        for (WSDLDefinition d : this.imported) {
            if (d.getDefinition() != this.definition) continue;
            element2 = d.getXmlSchemaElement(name);
            if (element2 == null) break;
            return element2;
        }
        for (WSDLDefinition d : this.imported) {
            element2 = d.getXmlSchemaElement(name);
            if (element2 == null) continue;
            return element2;
        }
        return null;
    }

    @Override
    public XmlSchemaType getXmlSchemaType(QName name) {
        WSDLDefinition d;
        XmlSchemaType type;
        XmlSchemaType type2;
        XmlSchemaCollection schemaCollection = null;
        for (XSDefinition xsd : this.schemas) {
            if (xsd.getSchemaCollection() != null) {
                schemaCollection = xsd.getSchemaCollection();
            }
            if ((type2 = xsd.getXmlSchemaType(name)) == null) continue;
            return type2;
        }
        if (schemaCollection != null && (type = schemaCollection.getTypeByQName(name)) != null) {
            return type;
        }
        Iterator<Base> i$ = this.imported.iterator();
        while (i$.hasNext()) {
            d = (WSDLDefinition)i$.next();
            if (d.getDefinition() != this.definition) continue;
            type2 = d.getXmlSchemaType(name);
            if (type2 == null) break;
            return type2;
        }
        if ((i$ = this.imported.iterator()).hasNext() && (type2 = (d = (WSDLDefinition)i$.next()).getXmlSchemaType(name)) != null) {
            return type2;
        }
        return null;
    }

    private static <T extends WSDLElement> WSDLObject<T> getWSDLObject(Definition definition, Class<T> type, QName name) {
        if (definition == null) {
            return null;
        }
        Map map = null;
        if (type == PortType.class) {
            map = definition.getPortTypes();
        } else if (type == Service.class) {
            map = definition.getServices();
        } else if (type == Binding.class) {
            map = definition.getBindings();
        } else if (type == Message.class) {
            map = definition.getMessages();
        } else {
            throw new IllegalArgumentException("Invalid type: " + type.getName());
        }
        if (map.containsKey(name)) {
            return new WSDLObjectImpl<Serializable>(definition, (Serializable)map.get(name));
        }
        for (Object imports : definition.getImports().values()) {
            List importList = (List)imports;
            for (Import i : importList) {
                definition = i.getDefinition();
                WSDLObject<T> element = WSDLDefinitionImpl.getWSDLObject(definition, type, name);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public <T extends WSDLElement> WSDLObject<T> getWSDLObject(Class<T> type, QName name) {
        return WSDLDefinitionImpl.getWSDLObject(this.definition, type, name);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public QName getNameOfPortTypeToResolve() {
        return this.nameOfPortTypeToResolve;
    }

    @Override
    public void setNameOfPortTypeToResolve(QName nameOfPortTypeToResolve) {
        this.nameOfPortTypeToResolve = nameOfPortTypeToResolve;
    }

    @Override
    public QName getNameOfBindingToResolve() {
        return this.nameOfBindingToResolve;
    }

    @Override
    public void setNameOfBindingToResolve(QName nameOfBindingToResolve) {
        this.nameOfBindingToResolve = nameOfBindingToResolve;
    }

    @Override
    public QName getNameOfServiceToResolve() {
        return this.nameOfServiceToResolve;
    }

    @Override
    public void setNameOfServiceToResolve(QName nameOfServiceToResolve) {
        this.nameOfServiceToResolve = nameOfServiceToResolve;
    }

    @Override
    public Map<String, String> getWsdliLocations() {
        return this.wsdliLocations;
    }

    @Override
    public XSDefinition getSchema(String namespace) {
        for (XSDefinition xsDef : this.schemas) {
            if (!xsDef.getNamespace().equals(namespace)) continue;
            return xsDef;
        }
        return null;
    }
}

