/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;

public class OperationImpl
implements Operation {
    private String name;
    private boolean unresolved;
    private DataType<List<DataType>> inputType;
    private List<DataType> faultTypes;
    private Interface interfaze;
    private List<ParameterMode> parameterModes = new ArrayList<ParameterMode>();
    private boolean nonBlocking;
    private boolean inputWrapperStyle;
    private boolean outputWrapperStyle;
    private WrapperInfo inputWrapper;
    private WrapperInfo outputWrapper;
    private boolean dynamic;
    private boolean notSubjectToWrapping;
    private Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
    private Map<QName, List<DataType<XMLType>>> faultBeans;
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private ExtensionType type;
    private DataType<List<DataType>> outputType;
    private boolean hasArrayWrappedOutput;

    public OperationImpl() {
        this.inputType = new DataTypeImpl("idl:input", Object[].class, new ArrayList());
        this.outputType = new DataTypeImpl("idl:output", Object[].class, new ArrayList());
        this.faultTypes = new ArrayList<DataType>();
        this.faultBeans = new HashMap<QName, List<DataType<XMLType>>>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public List<DataType> getFaultTypes() {
        return this.faultTypes;
    }

    @Override
    public void setFaultTypes(List<DataType> faultTypes) {
        this.faultTypes = faultTypes;
    }

    @Override
    public DataType<List<DataType>> getInputType() {
        return this.inputType;
    }

    @Override
    public void setInputType(DataType<List<DataType>> inputType) {
        this.inputType = inputType;
    }

    @Override
    public DataType<List<DataType>> getOutputType() {
        return this.outputType;
    }

    @Override
    public void setOutputType(DataType<List<DataType>> outputType) {
        this.outputType = outputType;
    }

    @Override
    public Interface getInterface() {
        return this.interfaze;
    }

    @Override
    public void setInterface(Interface interfaze) {
        this.interfaze = interfaze;
    }

    @Override
    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    @Override
    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    @Override
    public WrapperInfo getInputWrapper() {
        return this.inputWrapper;
    }

    @Override
    public void setInputWrapper(WrapperInfo wrapperInfo) {
        this.inputWrapper = wrapperInfo;
    }

    @Override
    public WrapperInfo getOutputWrapper() {
        return this.outputWrapper;
    }

    @Override
    public void setOutputWrapper(WrapperInfo wrapperInfo) {
        this.outputWrapper = wrapperInfo;
    }

    @Override
    public boolean isInputWrapperStyle() {
        return this.inputWrapperStyle;
    }

    @Override
    public void setInputWrapperStyle(boolean wrapperStyle) {
        this.inputWrapperStyle = wrapperStyle;
    }

    @Override
    public boolean isOutputWrapperStyle() {
        return this.outputWrapperStyle;
    }

    @Override
    public void setOutputWrapperStyle(boolean wrapperStyle) {
        this.outputWrapperStyle = wrapperStyle;
    }

    @Override
    public String getDataBinding() {
        if (this.inputWrapper != null) {
            return this.inputWrapper.getDataBinding();
        }
        if (this.outputWrapper != null) {
            return this.outputWrapper.getDataBinding();
        }
        return null;
    }

    @Override
    public void setDataBinding(String dataBinding) {
        if (this.inputWrapper != null) {
            this.inputWrapper.setDataBinding(dataBinding);
        }
        if (this.outputWrapper != null) {
            this.outputWrapper.setDataBinding(dataBinding);
        }
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void setDynamic(boolean b) {
        this.dynamic = b;
    }

    @Override
    public Map<QName, List<DataType<XMLType>>> getFaultBeans() {
        return this.faultBeans;
    }

    @Override
    public void setFaultBeans(Map<QName, List<DataType<XMLType>>> faultBeans) {
        this.faultBeans = faultBeans;
    }

    @Override
    public OperationImpl clone() throws CloneNotSupportedException {
        OperationImpl copy = (OperationImpl)super.clone();
        ArrayList<DataType> clonedFaultTypes = new ArrayList<DataType>(this.faultTypes.size());
        for (DataType t : this.faultTypes) {
            clonedFaultTypes.add((DataType)t.clone());
        }
        copy.faultTypes = clonedFaultTypes;
        ArrayList<DataType> clonedLogicalTypes = new ArrayList<DataType>();
        for (DataType t : this.inputType.getLogical()) {
            DataType type = (DataType)t.clone();
            clonedLogicalTypes.add(type);
        }
        DataTypeImpl clonedInputType = new DataTypeImpl(this.inputType.getPhysical(), clonedLogicalTypes);
        clonedInputType.setDataBinding(this.inputType.getDataBinding());
        copy.inputType = clonedInputType;
        if (this.outputType != null) {
            ArrayList<DataType> clonedLogicalOutputTypes = new ArrayList<DataType>();
            for (DataType t : this.outputType.getLogical()) {
                if (t == null) {
                    clonedLogicalOutputTypes.add(null);
                    continue;
                }
                DataType type = (DataType)t.clone();
                clonedLogicalOutputTypes.add(type);
            }
            DataTypeImpl clonedOutputType = new DataTypeImpl(this.outputType.getPhysical(), clonedLogicalOutputTypes);
            clonedOutputType.setDataBinding(this.outputType.getDataBinding());
            copy.outputType = clonedOutputType;
        }
        copy.attributes = new ConcurrentHashMap<Object, Object>();
        copy.attributes.putAll(this.attributes);
        if (this.inputWrapper != null) {
            copy.inputWrapper = (WrapperInfo)this.inputWrapper.clone();
        }
        if (this.outputWrapper != null) {
            copy.outputWrapper = (WrapperInfo)this.outputWrapper.clone();
        }
        return copy;
    }

    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    @Override
    public ExtensionType getExtensionType() {
        return this.type;
    }

    @Override
    public void setExtensionType(ExtensionType type) {
        this.type = type;
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isAsyncServer() {
        return false;
    }

    @Override
    public List<ParameterMode> getParameterModes() {
        return this.parameterModes;
    }

    @Override
    public boolean hasArrayWrappedOutput() {
        return this.hasArrayWrappedOutput;
    }

    @Override
    public void setHasArrayWrappedOutput(boolean value) {
        this.hasArrayWrappedOutput = value;
    }

    @Override
    public void setNotSubjectToWrapping(boolean notSubjectToWrapping) {
        this.notSubjectToWrapping = notSubjectToWrapping;
    }

    @Override
    public boolean isNotSubjectToWrapping() {
        return this.notSubjectToWrapping;
    }
}

