/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.ImplementationImpl;
import org.apache.tuscany.sca.implementation.spring.SpringBeanElement;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;

public class SpringImplementation
extends ImplementationImpl
implements Implementation,
Extensible {
    public static final QName TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.spring");
    private String location = null;
    private List<URL> resource = null;
    private ComponentType componentType;
    private Map<String, SpringBeanElement> serviceMap;
    private Map<String, Class<?>> propertyMap;
    private Map<String, Reference> unresolvedBeanRef;
    private ClassLoader classLoader;

    public SpringImplementation() {
        super(TYPE);
        this.setUnresolved(true);
        this.serviceMap = new HashMap<String, SpringBeanElement>();
        this.propertyMap = new HashMap();
        this.unresolvedBeanRef = new HashMap<String, Reference>();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setResource(List<URL> resource) {
        this.resource = resource;
    }

    public List<URL> getResource() {
        return this.resource;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    @Override
    public List<Service> getServices() {
        return this.componentType.getServices();
    }

    @Override
    public List<Reference> getReferences() {
        return this.componentType.getReferences();
    }

    @Override
    public List<Property> getProperties() {
        return this.componentType.getProperties();
    }

    public SpringBeanElement getBeanFromService(Service service) {
        SpringBeanElement theBean = this.serviceMap.get(service.getName());
        return theBean;
    }

    public void setBeanForService(Service service, SpringBeanElement theBean) {
        this.serviceMap.put(service.getName(), theBean);
    }

    public void setPropertyClass(String propertyName, Class<?> propertyClass) {
        if (propertyName == null || propertyClass == null) {
            return;
        }
        this.propertyMap.put(propertyName, propertyClass);
    }

    public Class<?> getPropertyClass(String propertyName) {
        return this.propertyMap.get(propertyName);
    }

    public void setUnresolvedBeanRef(String refName, Reference reference) {
        if (refName == null || reference == null) {
            return;
        }
        this.unresolvedBeanRef.put(refName, reference);
    }

    public Reference getUnresolvedBeanRef(String refName) {
        return this.unresolvedBeanRef.get(refName);
    }

    public void build(Component component) {
        for (ComponentReference reference : component.getReferences()) {
            if (!this.unresolvedBeanRef.containsKey(reference.getName())) continue;
            Reference ref = this.unresolvedBeanRef.get(reference.getName());
            this.componentType.getReferences().add(this.createReference(reference, ref.getInterfaceContract()));
            this.unresolvedBeanRef.remove(reference.getName());
        }
        for (ComponentProperty property : component.getProperties()) {
            if (!this.unresolvedBeanRef.containsKey(property.getName())) continue;
            this.componentType.getProperties().add(this.createProperty(property));
            this.setPropertyClass(property.getName(), property.getClass());
            this.unresolvedBeanRef.remove(property.getName());
        }
    }

    protected Reference createReference(Reference reference, InterfaceContract interfaze) {
        Reference newReference;
        try {
            newReference = (Reference)reference.clone();
            if (newReference.getInterfaceContract() == null) {
                newReference.setInterfaceContract(interfaze);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newReference;
    }

    protected Property createProperty(Property property) {
        Property newProperty;
        try {
            newProperty = (Property)property.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newProperty;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SpringImplementation)) {
            return false;
        }
        SpringImplementation other = (SpringImplementation)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpringImplementation [location=").append(this.location).append(", resource=").append(this.resource).append("]");
        return builder.toString();
    }
}

