/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.xml.JavaImplementationConstants;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class JavaImplementationProcessor
implements StAXArtifactProcessor<JavaImplementation> {
    private JavaImplementationFactory javaFactory;
    private AssemblyFactory assemblyFactory;
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private transient InterfaceContractMapper interfaceContractMapper;

    public JavaImplementationProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor<?> staxProcessor) {
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.javaFactory = modelFactories.getFactory(JavaImplementationFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
        this.extensionProcessor = staxProcessor;
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-javaxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-javaxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    @Override
    public JavaImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        int event;
        JavaImplementation javaImplementation = this.javaFactory.createJavaImplementation();
        ImplementationType implType = this.policyFactory.createImplementationType();
        implType.setType(this.getArtifactType());
        implType.setUnresolved(true);
        javaImplementation.setExtensionType(implType);
        javaImplementation.setUnresolved(true);
        javaImplementation.setName(reader.getAttributeValue(null, "class"));
        this.policyProcessor.readPolicies(javaImplementation, reader);
        while (reader.hasNext() && ((event = reader.next()) != 2 || !JavaImplementationConstants.IMPLEMENTATION_JAVA_QNAME.equals(reader.getName()))) {
        }
        return javaImplementation;
    }

    @Override
    public void write(JavaImplementation javaImplementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.java");
        this.policyProcessor.writePolicyAttributes(javaImplementation, writer);
        if (javaImplementation.getName() != null) {
            writer.writeAttribute("class", javaImplementation.getName());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(JavaImplementation javaImplementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Monitor monitor = context.getMonitor();
        try {
            ClassReference classReference = new ClassReference(javaImplementation.getName());
            classReference = resolver.resolveModel(ClassReference.class, classReference, context);
            Class<?> javaClass = classReference.getJavaClass();
            if (javaClass == null) {
                this.error(monitor, "ClassNotFoundException", (Object)resolver, javaImplementation.getName());
                return;
            }
            javaImplementation.setJavaClass(javaClass);
            try {
                this.javaFactory.createJavaImplementation(javaImplementation, javaImplementation.getJavaClass());
            }
            catch (IntrospectionException e) {
                ContributionResolveException ce = new ContributionResolveException(e);
                this.error(monitor, "ContributionResolveException", (Object)this.javaFactory, ce);
                return;
            }
            this.checkNoStaticAnnotations(monitor, javaImplementation);
            this.postJAXWSProcessorResolve(resolver, javaImplementation, context);
            javaImplementation.setUnresolved(false);
            this.mergeComponentType(resolver, javaImplementation, context);
            if (javaImplementation.getServices().isEmpty()) {
                javaImplementation.getServices().add(this.assemblyFactory.createService());
            }
        }
        catch (Throwable e) {
            String message = context.getMonitor().getMessageString(JavaImplementationProcessor.class.getName(), "impl-javaxml-validation-messages", "ResolvingJavaImplementation");
            message = message.replace("{0}", javaImplementation.getName());
            message = message.replace("{1}", e.getMessage());
            throw new ContributionResolveException(message, e);
        }
    }

    private void checkNoStaticAnnotations(Monitor monitor, JavaImplementation javaImplementation) {
        if (javaImplementation.getJavaClass() != null) {
            Class<?> clazz = javaImplementation.getJavaClass();
            for (Method method : clazz.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                for (Annotation a : method.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith("org.oasisopen.sca.annotation")) continue;
                    this.error(monitor, "IllegalSCAAnnotation", (Object)this.javaFactory, javaImplementation.getName(), method.getName());
                }
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (!Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                for (Annotation a : accessibleObject.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith("org.oasisopen.sca.annotation")) continue;
                    this.error(monitor, "IllegalSCAAnnotation", (Object)this.javaFactory, javaImplementation.getName(), ((Field)accessibleObject).getName());
                }
            }
        }
    }

    private JavaElementImpl getMemeber(JavaImplementation impl, String name, Class<?> type) {
        String setter = JavaIntrospectionHelper.toSetter(name);
        try {
            Method method = impl.getJavaClass().getDeclaredMethod(setter, type);
            int mod = method.getModifiers();
            if ((Modifier.isPublic(mod) || Modifier.isProtected(mod)) && !Modifier.isStatic(mod)) {
                return new JavaElementImpl(method, 0);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = impl.getJavaClass().getDeclaredField(name);
                int mod = field.getModifiers();
                if ((Modifier.isPublic(mod) || Modifier.isProtected(mod)) && !Modifier.isStatic(mod)) {
                    return new JavaElementImpl(field);
                }
            }
            catch (NoSuchFieldException e1) {
                // empty catch block
            }
        }
        return null;
    }

    private void mergeComponentType(ModelResolver resolver, JavaImplementation impl, ProcessorContext context) {
        ComponentType componentType = this.getComponentType(resolver, impl, context);
        if (componentType != null && !componentType.isUnresolved()) {
            HashMap<String, Reference> refMap = new HashMap<String, Reference>();
            for (Reference ref : impl.getReferences()) {
                refMap.put(ref.getName(), ref);
            }
            for (Reference reference : componentType.getReferences()) {
                refMap.put(reference.getName(), reference);
            }
            impl.getReferences().clear();
            impl.getReferences().addAll(refMap.values());
            Map<String, JavaElementImpl> refMembers = impl.getReferenceMembers();
            for (Reference ref : impl.getReferences()) {
                JavaElementImpl e;
                Interface i;
                if (ref.getInterfaceContract() == null || !((i = ref.getInterfaceContract().getInterface()) instanceof JavaInterface)) continue;
                Class<?> type = ((JavaInterface)i).getJavaClass();
                if (refMembers.containsKey(ref.getName()) || (e = this.getMemeber(impl, ref.getName(), type)) == null) continue;
                refMembers.put(ref.getName(), e);
            }
            HashMap<String, Service> serviceMap = new HashMap<String, Service>();
            for (Service svc : impl.getServices()) {
                serviceMap.put(svc.getName(), svc);
            }
            for (Service service : componentType.getServices()) {
                serviceMap.put(service.getName(), service);
            }
            impl.getServices().clear();
            impl.getServices().addAll(serviceMap.values());
            HashMap<String, Property> propMap = new HashMap<String, Property>();
            for (Property prop : impl.getProperties()) {
                propMap.put(prop.getName(), prop);
            }
            for (Property property : componentType.getProperties()) {
                propMap.put(property.getName(), property);
            }
            impl.getProperties().clear();
            impl.getProperties().addAll(propMap.values());
        }
    }

    private void postJAXWSProcessorResolve(ModelResolver resolver, JavaImplementation impl, ProcessorContext context) throws ContributionResolveException, IncompatibleInterfaceContractException {
        for (Service service : impl.getServices()) {
            WSDLInterface wsdlInterface;
            WSDLInterfaceContract wsdlInterfaceContract;
            JavaInterfaceContract javaInterfaceContract = (JavaInterfaceContract)service.getInterfaceContract();
            JavaInterface javaInterface = (JavaInterface)javaInterfaceContract.getInterface();
            if (javaInterface.isUnresolved()) {
                this.extensionProcessor.resolve(javaInterfaceContract, resolver, context);
            }
            if ((wsdlInterfaceContract = (WSDLInterfaceContract)javaInterfaceContract.getNormalizedWSDLContract()) == null || !(wsdlInterface = (WSDLInterface)wsdlInterfaceContract.getInterface()).isUnresolved()) continue;
            this.extensionProcessor.resolve(wsdlInterfaceContract, resolver, context);
            this.interfaceContractMapper.checkCompatibility(wsdlInterfaceContract, javaInterfaceContract, Compatibility.SUBSET, false, false);
            wsdlInterface = (WSDLInterface)wsdlInterfaceContract.getInterface();
            javaInterface.getPolicySets().addAll(wsdlInterface.getPolicySets());
            javaInterface.getRequiredIntents().addAll(wsdlInterface.getRequiredIntents());
            service.getPolicySets().addAll(wsdlInterface.getPolicySets());
            service.getRequiredIntents().addAll(wsdlInterface.getRequiredIntents());
        }
    }

    private ComponentType getComponentType(ModelResolver resolver, JavaImplementation impl, ProcessorContext context) {
        String className = impl.getJavaClass().getName();
        String componentTypeURI = className.replace('.', '/') + ".componentType";
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        componentType.setURI(componentTypeURI);
        componentType = resolver.resolveModel(ComponentType.class, componentType, context);
        if (!componentType.isUnresolved()) {
            return componentType;
        }
        return null;
    }

    @Override
    public QName getArtifactType() {
        return JavaImplementationConstants.IMPLEMENTATION_JAVA_QNAME;
    }

    @Override
    public Class<JavaImplementation> getModelType() {
        return JavaImplementation.class;
    }
}

