/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Qualifier;
import org.oasisopen.sca.annotation.Requires;

public class PolicyProcessor
extends BaseJavaClassVisitor {
    private PolicyFactory policyFactory;

    public PolicyProcessor(AssemblyFactory assemblyFactory, PolicyFactory policyFactory, JavaInterfaceFactory javaInterfaceFactory) {
        super(assemblyFactory);
        this.policyFactory = policyFactory;
        this.javaInterfaceFactory = javaInterfaceFactory;
    }

    public PolicyProcessor(ExtensionPointRegistry registry) {
        super(registry);
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = factories.getFactory(PolicyFactory.class);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        this.readPolicySetAndIntents((PolicySubject)type, clazz);
        HashSet<Method> methods = new HashSet<Method>();
        for (Service service : type.getServices()) {
            for (Operation operation : service.getInterfaceContract().getInterface().getOperations()) {
                Method method;
                try {
                    method = JavaInterfaceUtil.findMethod(clazz, operation);
                }
                catch (NoSuchMethodException e1) {
                    throw new IntrospectionException(e1);
                }
                if (method == null) continue;
                methods.add(method);
            }
        }
        for (Method method : methods) {
            JavaOperation op = this.javaInterfaceFactory.createJavaOperation(method);
            type.getOperations().add(op);
        }
        HashMap<String, Reference> referenceMap = new HashMap<String, Reference>();
        for (Reference ref : type.getReferences()) {
            referenceMap.put(ref.getName(), ref);
        }
        Map<String, JavaElementImpl> members = type.getReferenceMembers();
        for (Map.Entry entry : members.entrySet()) {
            Reference reference = (Reference)referenceMap.get(entry.getKey());
            this.readPolicySetAndIntents((PolicySubject)reference, ((JavaElementImpl)entry.getValue()).getAnchor());
        }
    }

    private void readPolicySetAndIntents(PolicySubject subject, AnnotatedElement element) {
        this.readIntents(element.getAnnotation(Requires.class), subject.getRequiredIntents());
        this.readSpecificIntents(element.getAnnotations(), subject.getRequiredIntents());
        this.readPolicySets(element.getAnnotation(PolicySets.class), subject.getPolicySets());
    }

    private void readPolicySetAndIntents(PolicySubject subject, JavaElementImpl element) {
        this.readIntents(element.getAnnotation(Requires.class), subject.getRequiredIntents());
        this.readSpecificIntents(element.getAnnotations(), subject.getRequiredIntents());
        this.readPolicySets(element.getAnnotation(PolicySets.class), subject.getPolicySets());
    }

    private void readSpecificIntents(Annotation[] annotations, List<Intent> requiredIntents) {
        for (Annotation a : annotations) {
            org.oasisopen.sca.annotation.Intent intentAnnotation = a.annotationType().getAnnotation(org.oasisopen.sca.annotation.Intent.class);
            if (intentAnnotation == null) continue;
            QName qname = null;
            String value = intentAnnotation.value();
            qname = !value.equals("") ? PolicyProcessor.getQName(value) : new QName(intentAnnotation.targetNamespace(), intentAnnotation.localPart());
            HashSet<String> qualifiers = new HashSet<String>();
            for (Method m : a.annotationType().getMethods()) {
                Qualifier qualifier = m.getAnnotation(Qualifier.class);
                if (qualifier == null || m.getReturnType() != String[].class) continue;
                try {
                    qualifiers.addAll(Arrays.asList((String[])m.invoke((Object)a, new Object[0])));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            qualifiers.remove("");
            if (qualifiers.isEmpty()) {
                Intent intent = this.policyFactory.createIntent();
                intent.setUnresolved(true);
                intent.setName(qname);
                requiredIntents.add(intent);
                continue;
            }
            for (String q : qualifiers) {
                Intent intent = this.policyFactory.createIntent();
                intent.setUnresolved(true);
                qname = new QName(qname.getNamespaceURI(), qname.getLocalPart() + "." + q);
                intent.setName(qname);
                requiredIntents.add(intent);
            }
        }
    }

    private void readIntents(Requires intentAnnotation, List<Intent> requiredIntents) {
        String[] intentNames;
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(PolicyProcessor.getQName(intentName));
                requiredIntents.add(intent);
            }
        }
    }

    private void readPolicySets(PolicySets policySetAnnotation, List<PolicySet> policySets) {
        String[] policySetNames;
        if (policySetAnnotation != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(PolicyProcessor.getQName(policySetName));
                policySets.add(policySet);
            }
        }
    }

    private static QName getQName(String intentName) {
        int i;
        QName qname = intentName.startsWith("{") ? ((i = intentName.indexOf(125)) != -1 ? new QName(intentName.substring(1, i), intentName.substring(i + 1)) : new QName("", intentName)) : new QName("", intentName);
        return qname;
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        JavaElementImpl element = new JavaElementImpl(field);
        if (!type.getReferenceMembers().values().contains(element)) {
            Component subject = this.assemblyFactory.createComponent();
            this.readPolicySetAndIntents((PolicySubject)subject, field);
            if (subject.getPolicySets().isEmpty() && subject.getRequiredIntents().isEmpty()) {
                return;
            }
            throw new ServiceRuntimeException("[JCA70002,JCA70005] Field that is not an SCA reference cannot have policySet/intent annotations: " + field);
        }
    }

    @Override
    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) {
        if (!type.getReferenceMembers().values().contains(parameter)) {
            Component subject = this.assemblyFactory.createComponent();
            this.readPolicySetAndIntents((PolicySubject)subject, parameter);
            if (subject.getPolicySets().isEmpty() && subject.getRequiredIntents().isEmpty()) {
                return;
            }
            throw new ServiceRuntimeException("[JCA70002,JCA70005] Constructor parameter that is not an SCA reference cannot have policySet/intent annotations: " + parameter);
        }
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        HashSet<AnnotatedElement> annotatedElements = new HashSet<AnnotatedElement>();
        for (JavaElementImpl element : type.getReferenceMembers().values()) {
            annotatedElements.add(element.getAnchor());
        }
        if (!annotatedElements.contains(method)) {
            Component subject = this.assemblyFactory.createComponent();
            this.readPolicySetAndIntents((PolicySubject)subject, method);
            if (subject.getPolicySets().isEmpty() && subject.getRequiredIntents().isEmpty()) {
                return;
            }
            throw new ServiceRuntimeException("[JCA70002,JCA70005] Method that is not an SCA reference cannot have policySet/intent annotations: " + method);
        }
    }
}

