/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.oasisopen.sca.annotation.AllowsPassByReference;

public class AllowsPassByReferenceProcessor
extends BaseJavaClassVisitor {
    public AllowsPassByReferenceProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public AllowsPassByReferenceProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        type.setAllowsPassByReference(clazz.isAnnotationPresent(AllowsPassByReference.class));
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        boolean pbr = method.isAnnotationPresent(AllowsPassByReference.class);
        if (pbr) {
            type.getAllowsPassByReferenceMethods().add(method);
        }
    }
}

