/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.ResourceHost;
import org.apache.tuscany.sca.implementation.java.ResourceResolutionException;
import org.apache.tuscany.sca.implementation.java.injection.ResourceNotFoundException;

public class ResourceObjectFactory<T>
implements ObjectFactory<T> {
    private Class<T> type;
    private String mappedName;
    private ResourceHost host;
    private boolean optional;

    public ResourceObjectFactory(Class<T> type, boolean optional, ResourceHost host) {
        this(type, null, optional, host);
    }

    public ResourceObjectFactory(Class<T> type, String mappedName, boolean optional, ResourceHost host) {
        this.type = type;
        this.host = host;
        this.mappedName = mappedName;
        this.optional = optional;
    }

    @Override
    public T getInstance() throws ObjectCreationException {
        try {
            T resource;
            if (this.mappedName == null) {
                resource = this.host.resolveResource(this.type);
                if (!this.optional && resource == null) {
                    throw new ResourceNotFoundException("Resource not found: " + this.type.getName());
                }
            } else {
                resource = this.host.resolveResource(this.type, this.mappedName);
                if (!this.optional && resource == null) {
                    throw new ResourceNotFoundException("Resource not found: " + this.mappedName);
                }
            }
            return resource;
        }
        catch (ResourceResolutionException e) {
            throw new ObjectCreationException(e);
        }
    }
}

