/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.databinding;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class PropertyDataTypeProcessor
extends BaseJavaClassVisitor {
    private Mediator mediator;

    public PropertyDataTypeProcessor(ExtensionPointRegistry registry) {
        super(registry);
        UtilityExtensionPoint utilityExtensionPoint = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.mediator = utilityExtensionPoint.getUtility(Mediator.class);
    }

    private void introspect(Property property, JavaElementImpl javaElement) {
        this.mediator.getDataBindings().introspectType(property.getDataType(), null);
    }

    @Override
    public <T> void visitEnd(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        for (Property property : type.getProperties()) {
            String name = property.getName();
            JavaElementImpl element = type.getPropertyMembers().get(name);
            this.introspect(property, element);
            DataType dt = property.getDataType();
            Object logical = dt.getLogical();
            if (logical instanceof XMLType && logical != XMLType.UNKNOWN) {
                XMLType xmlType = (XMLType)logical;
                property.setXSDType(xmlType.getTypeName());
                property.setXSDElement(xmlType.getElementName());
                continue;
            }
            Class<?> baseType = JavaIntrospectionHelper.getBaseType(element.getType(), element.getGenericType());
            QName typeName = JavaXMLMapper.getXMLType(baseType);
            property.setXSDType(typeName);
        }
        super.visitEnd(clazz, type);
    }
}

