/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl;

import java.beans.Introspector;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.TuscanyRuntime;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.xml.Utils;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.impl.ContributionHelper;
import org.apache.tuscany.sca.impl.DeployedComposite;
import org.apache.tuscany.sca.impl.RemoteCommand;
import org.apache.tuscany.sca.impl.ServiceHelper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.ActiveNodes;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.ContributionDescription;
import org.apache.tuscany.sca.runtime.ContributionListener;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.oasisopen.sca.NoSuchServiceException;
import sun.misc.ClassLoaderUtil;

public class NodeImpl
implements Node {
    private static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    private Deployer deployer;
    private CompositeActivator compositeActivator;
    private DomainRegistry domainRegistry;
    private ExtensionPointRegistry extensionPointRegistry;
    private UtilityExtensionPoint utilityExtensionPoint;
    private TuscanyRuntime tuscanyRuntime;
    private Map<String, Contribution> loadedContributions = new ConcurrentHashMap<String, Contribution>();
    private Map<String, DeployedComposite> startedComposites = new HashMap<String, DeployedComposite>();
    private Map<String, DeployedComposite> stoppedComposites = new HashMap<String, DeployedComposite>();
    private boolean endpointsIncludeDomainName;
    private boolean quietLogging;
    private boolean releaseOnUnload;
    private ContributionListener contributionListener;

    public NodeImpl(Deployer deployer, CompositeActivator compositeActivator, DomainRegistry domainRegistry, ExtensionPointRegistry extensionPointRegistry, TuscanyRuntime tuscanyRuntime) {
        this.deployer = deployer;
        this.compositeActivator = compositeActivator;
        this.domainRegistry = domainRegistry;
        this.extensionPointRegistry = extensionPointRegistry;
        this.tuscanyRuntime = tuscanyRuntime;
        this.utilityExtensionPoint = extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class);
        this.utilityExtensionPoint.getUtility(ActiveNodes.class).getActiveNodes().add(this);
        this.contributionListener = new ContributionListener(){

            @Override
            public void contributionInstalled(String uri) {
            }

            @Override
            public void contributionUpdated(String uri) {
                this.unloadContribution(uri);
            }

            @Override
            public void contributionRemoved(String uri) {
                this.unloadContribution(uri);
            }

            private void unloadContribution(String curi) {
                Contribution c = (Contribution)NodeImpl.this.loadedContributions.remove(curi);
                if (c != null) {
                    ClassLoader cl = c.getClassLoader();
                    ContributionHelper.close(c, NodeImpl.this.extensionPointRegistry);
                    if (NodeImpl.this.releaseOnUnload && cl instanceof URLClassLoader) {
                        ClassLoaderUtil.releaseLoader((URLClassLoader)((URLClassLoader)cl));
                    }
                }
            }
        };
        this.domainRegistry.addContributionListener(this.contributionListener);
        this.endpointsIncludeDomainName = !"default".equals(domainRegistry.getDomainName());
        UtilityExtensionPoint utilities = extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class);
        this.releaseOnUnload = Boolean.parseBoolean(utilities.getUtility(RuntimeProperties.class).getProperties().getProperty("org.apache.tuscany.sca.releaseOnUnload", "true"));
        this.quietLogging = Boolean.parseBoolean(utilities.getUtility(RuntimeProperties.class).getProperties().getProperty("org.apache.tuscany.sca.quietLogging"));
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "domain: " + domainRegistry.getDomainName() + (!domainRegistry.getDomainName().equals(domainRegistry.getDomainURI()) ? "" : " domainURI: " + domainRegistry.getDomainURI()));
        }
    }

    @Override
    public String installContribution(String contributionURL) throws ContributionReadException, ValidationException {
        return this.installContribution(null, contributionURL, null, null);
    }

    public String installContribution(String uri, String contributionURL) throws ContributionReadException, ValidationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "updateUsingComposites", contributionURL);
        }
        return this.installContribution(uri, contributionURL, null, null);
    }

    public boolean updateContribution(String uri, String contributionURL, String metaDataURL, List<String> dependentContributionURIs) throws ContributionReadException, ValidationException, ActivationException {
        ContributionDescription ic;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "updateContribution" + Arrays.asList(uri, contributionURL, metaDataURL, dependentContributionURIs));
        }
        if ((ic = this.domainRegistry.getInstalledContribution(uri)) == null) {
            this.installContribution(uri, contributionURL, metaDataURL, dependentContributionURIs);
            return true;
        }
        this.uninstallContribution(uri);
        this.installContribution(uri, contributionURL, metaDataURL, dependentContributionURIs);
        if (ic.getAdditionalDeployables().size() > 0) {
            ContributionDescription newIC = this.getInstalledContribution(uri);
            newIC.getAdditionalDeployables().putAll(ic.getAdditionalDeployables());
            this.domainRegistry.updateInstalledContribution(newIC);
        }
        for (DeployedComposite dc : new ArrayList<DeployedComposite>(this.startedComposites.values())) {
            if (!dc.getContributionURIs().contains(uri)) continue;
            String dcContributionURI = dc.getContributionURIs().get(0);
            String dcCompositeURI = dc.getURI();
            this.stopComposite(dcContributionURI, dcCompositeURI);
            String key = dcContributionURI + "/" + dcCompositeURI;
            this.stoppedComposites.remove(key);
            this.startComposite(dcContributionURI, dcCompositeURI);
        }
        for (DeployedComposite dc : new ArrayList<DeployedComposite>(this.stoppedComposites.values())) {
            if (!dc.getContributionURIs().contains(uri)) continue;
            this.stoppedComposites.remove(uri + "/" + dc.getURI());
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "updateContribution: " + uri);
        }
        return true;
    }

    @Override
    public String installContribution(String uri, String contributionURL, String metaDataURL, List<String> dependentContributionURIs) throws ContributionReadException, ValidationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "installContribution" + Arrays.asList(uri, contributionURL, metaDataURL, dependentContributionURIs));
        }
        ContributionDescription cd = new ContributionDescription(uri, IOHelper.getLocationAsURL(contributionURL).toString());
        if (dependentContributionURIs != null) {
            cd.getDependentContributionURIs().addAll(dependentContributionURIs);
        }
        if (metaDataURL != null) {
            this.mergeContributionMetaData(metaDataURL, this.loadContribution(cd));
        }
        this.peekIntoContribution(cd);
        this.domainRegistry.installContribution(cd);
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "installContribution: " + cd.getURI());
        }
        return cd.getURI();
    }

    @Override
    public void installContribution(Contribution contribution, List<String> dependentContributionURIs) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "installContribution" + Arrays.asList(contribution, dependentContributionURIs));
        }
        ContributionDescription cd = new ContributionDescription(contribution.getURI(), contribution.getLocation());
        if (dependentContributionURIs != null) {
            cd.getDependentContributionURIs().addAll(dependentContributionURIs);
        }
        cd.configureMetaData(contribution);
        this.domainRegistry.installContribution(cd);
        this.loadedContributions.put(cd.getURI(), contribution);
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "installContribution: " + cd.getURI());
        }
    }

    @Override
    public void uninstallContribution(String contributionURI) {
        this.domainRegistry.uninstallContribution(contributionURI);
        Iterator<String> i = this.stoppedComposites.keySet().iterator();
        while (i.hasNext()) {
            DeployedComposite dc = this.stoppedComposites.get(i.next());
            if (!dc.getContributionURIs().contains(contributionURI)) continue;
            i.remove();
        }
        if (this.loadedContributions.size() < 1) {
            DOMHelper.getInstance(this.extensionPointRegistry).stop();
            Introspector.flushCaches();
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "uninstallContribution: " + contributionURI);
        }
    }

    protected void mergeContributionMetaData(String metaDataURL, Contribution contribution) throws ValidationException {
        ContributionMetadata metaData;
        Monitor monitor = this.deployer.createMonitor();
        try {
            metaData = (ContributionMetadata)this.deployer.loadXMLDocument(IOHelper.getLocationAsURL(metaDataURL), monitor);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        monitor.analyzeProblems();
        contribution.mergeMetaData(metaData);
    }

    protected void peekIntoContribution(ContributionDescription cd) {
        Contribution contribution = null;
        try {
            contribution = this.loadContribution(cd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (contribution != null) {
            cd.configureMetaData(contribution);
        }
    }

    @Override
    public List<String> getInstalledContributionURIs() {
        return new ArrayList<String>(this.domainRegistry.getInstalledContributionURIs());
    }

    @Override
    public Contribution getContribution(String contributionURI) throws ContributionReadException, ValidationException {
        return this.loadContribution(this.getInstalledContribution(contributionURI));
    }

    @Override
    public List<String> getDeployableCompositeURIs(String contributionURI) {
        ContributionDescription cd = this.domainRegistry.getInstalledContribution(contributionURI);
        ArrayList<String> deployables = new ArrayList<String>(cd.getDeployables());
        deployables.addAll(cd.getAdditionalDeployables().keySet());
        return deployables;
    }

    @Override
    public String addDeploymentComposite(String contributionURI, Reader compositeXML) throws ContributionReadException, XMLStreamException, ValidationException {
        ContributionDescription cd = this.getInstalledContribution(contributionURI);
        Composite composite = (Composite)this.deployer.loadXMLDocument(compositeXML);
        return this.addDeploymentComposite(cd, composite);
    }

    @Override
    public String addDeploymentComposite(String contributionURI, Composite composite) {
        ContributionDescription cd = this.getInstalledContribution(contributionURI);
        return this.addDeploymentComposite(cd, composite);
    }

    protected String addDeploymentComposite(ContributionDescription cd, Composite composite) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addDeploymentComposite" + Arrays.asList(cd, composite));
        }
        if (composite.getURI() == null || composite.getURI().length() < 1) {
            composite.setURI(composite.getName().getLocalPart() + ".composite");
        }
        composite.setContributionURI(cd.getURI());
        cd.getAdditionalDeployables().put(composite.getURI(), Utils.modelToXML(composite, false, this.extensionPointRegistry));
        this.domainRegistry.updateInstalledContribution(cd);
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "addDeploymentComposite: " + composite.getURI());
        }
        return composite.getURI();
    }

    @Override
    public void validateContribution(String contributionURI) throws ContributionReadException, ValidationException {
        ModelResolver o;
        ContributionDescription cd = this.getInstalledContribution(contributionURI);
        Contribution contribution = this.loadContribution(cd);
        Monitor monitor = this.deployer.createMonitor();
        try {
            ArrayList<Contribution> cs = new ArrayList<Contribution>();
            cs.add(contribution);
            cs.addAll(this.calculateDependentContributions(cd));
            this.deployer.resolve(cs, null, monitor);
        }
        catch (Exception e) {
            this.loadedContributions.remove(cd.getURI());
            throw new RuntimeException(e);
        }
        try {
            monitor.analyzeProblems();
        }
        catch (ValidationException e) {
            this.loadedContributions.remove(cd.getURI());
            throw e;
        }
        if (contribution.getClassLoader() == null && contribution.getModelResolver() instanceof ExtensibleModelResolver && (o = ((ExtensibleModelResolver)contribution.getModelResolver()).getModelResolverInstance(ClassReference.class)) instanceof ClassLoader) {
            contribution.setClassLoader((ClassLoader)((Object)o));
        }
    }

    @Override
    public Map<String, List<String>> getStartedCompositeURIs() {
        return Collections.unmodifiableMap(this.domainRegistry.getRunningCompositeURIs());
    }

    @Override
    public void startComposite(String contributionURI, String compositeURI) throws ActivationException, ValidationException, ContributionReadException {
        String key = contributionURI + "/" + compositeURI;
        if (this.startedComposites.containsKey(key)) {
            throw new IllegalStateException("composite already started: " + compositeURI);
        }
        DeployedComposite dc = this.stoppedComposites.remove(key);
        try {
            if (dc != null) {
                dc.start();
                this.startedComposites.put(key, dc);
            } else {
                ContributionDescription cd = this.getInstalledContribution(contributionURI);
                Contribution contribution = this.loadContribution(cd);
                Composite composite = (Composite)contribution.getArtifactModel(compositeURI);
                List<Contribution> dependentContributions = this.calculateDependentContributions(cd);
                dc = new DeployedComposite(composite, contribution, dependentContributions, this.deployer, this.compositeActivator, this.domainRegistry, this.extensionPointRegistry, this.endpointsIncludeDomainName);
                dc.start();
                this.startedComposites.put(key, dc);
            }
        }
        catch (ActivationException e) {
            if (dc != null) {
                try {
                    dc.stop();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.stoppedComposites.put(key, dc);
            }
            throw e;
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "startComposite: " + key);
        }
    }

    @Override
    public void startComposite(String contributionURI, String compositeURI, String nodeName) throws ActivationException {
        String response = this.domainRegistry.remoteCommand(nodeName, new RemoteCommand(this.domainRegistry.getDomainName(), "start", contributionURI, compositeURI));
        if (!"Started.".equals(response)) {
            throw new ActivationException(response);
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "startComposite: " + contributionURI + " " + compositeURI + " " + nodeName);
        }
    }

    @Override
    public void stopComposite(String contributionURI, String compositeURI) throws ActivationException {
        String key = contributionURI + "/" + compositeURI;
        DeployedComposite dc = this.startedComposites.remove(key);
        if (dc != null) {
            dc.stop();
            this.stoppedComposites.put(key, dc);
        } else {
            String member = this.domainRegistry.getRunningNodeName(contributionURI, compositeURI);
            if (member == null) {
                throw new IllegalStateException("composite not started: " + compositeURI);
            }
            RemoteCommand command = new RemoteCommand(this.domainRegistry.getDomainName(), "stop", contributionURI, compositeURI);
            String response = this.domainRegistry.remoteCommand(member, command);
            if (!"Stopped.".equals(response)) {
                throw new ActivationException(response);
            }
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "stopComposite: " + key);
        }
    }

    @Override
    public void stopCompositeAndUninstallUnused(String contributionURI, String compositeURI) throws ActivationException {
        String key = contributionURI + "/" + compositeURI;
        DeployedComposite dc = this.startedComposites.remove(key);
        if (dc != null) {
            dc.stop();
        } else {
            dc = this.stoppedComposites.get(key);
        }
        if (dc != null) {
            block0: for (String curi : dc.getContributionURIs()) {
                for (DeployedComposite started : this.startedComposites.values()) {
                    if (!started.getContributionURIs().contains(curi)) continue;
                    continue block0;
                }
                this.uninstallContribution(curi);
            }
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "stopCompositeAndUninstallUnused: " + key);
        }
    }

    @Override
    public String getDomainURI() {
        return this.domainRegistry.getDomainURI();
    }

    @Override
    public String getDomainName() {
        return this.domainRegistry.getDomainName();
    }

    @Override
    public Composite getDomainComposite() {
        return this.domainRegistry.getDomainComposite();
    }

    @Override
    public <T> T getService(Class<T> interfaze, String serviceURI) throws NoSuchServiceException {
        return ServiceHelper.getService(interfaze, serviceURI, this.domainRegistry, this.extensionPointRegistry, this.deployer);
    }

    @Override
    public ContributionDescription getInstalledContribution(String contributionURI) {
        ContributionDescription cd = this.domainRegistry.getInstalledContribution(contributionURI);
        if (cd == null) {
            throw new IllegalArgumentException("Contribution not installed: " + contributionURI);
        }
        return cd;
    }

    protected Contribution loadContribution(ContributionDescription cd) throws ContributionReadException, ValidationException {
        Contribution contribution = this.loadedContributions.get(cd.getURI());
        if (contribution == null) {
            Monitor monitor = this.deployer.createMonitor();
            contribution = this.deployer.loadContribution(IOHelper.createURI(cd.getURI()), IOHelper.getLocationAsURL(cd.getURL()), monitor);
            if (cd.getAdditionalDeployables().size() > 0) {
                for (String uri : cd.getAdditionalDeployables().keySet()) {
                    Composite composite;
                    String compositeXML = cd.getAdditionalDeployables().get(uri);
                    try {
                        composite = (Composite)this.deployer.loadXMLDocument(new StringReader(compositeXML));
                    }
                    catch (XMLStreamException e) {
                        throw new ContributionReadException(e);
                    }
                    composite.setURI(composite.getName().getLocalPart() + ".composite");
                    contribution.addComposite(composite);
                }
            }
            this.loadedContributions.put(cd.getURI(), contribution);
        }
        return contribution;
    }

    protected List<Contribution> calculateDependentContributions(ContributionDescription cd) throws ContributionReadException, ValidationException {
        HashMap<String, Contribution> dependentContributions = new HashMap<String, Contribution>();
        if (cd.getDependentContributionURIs() != null && cd.getDependentContributionURIs().size() > 0) {
            for (String uri : cd.getDependentContributionURIs()) {
                ContributionDescription dependee;
                if (dependentContributions.containsKey(uri) || (dependee = this.domainRegistry.getInstalledContribution(uri)) == null) continue;
                dependentContributions.put(uri, this.loadContribution(dependee));
            }
        } else {
            for (Import imprt : this.loadContribution(cd).getImports()) {
                for (ContributionDescription exportingIC : this.findExportingContributions(imprt)) {
                    if (dependentContributions.containsKey(exportingIC.getURI()) || cd.getURI().equals(exportingIC.getURI())) continue;
                    dependentContributions.put(exportingIC.getURI(), this.loadContribution(exportingIC));
                }
            }
        }
        return new ArrayList<Contribution>(dependentContributions.values());
    }

    private List<ContributionDescription> findExportingContributions(Import imprt) {
        ArrayList<ContributionDescription> ics = new ArrayList<ContributionDescription>();
        for (String curi : this.domainRegistry.getInstalledContributionURIs()) {
            ContributionDescription cd = this.domainRegistry.getInstalledContribution(curi);
            if (imprt instanceof JavaImport) {
                for (String s : cd.getJavaExports()) {
                    if (!s.startsWith(((JavaImport)imprt).getPackage())) continue;
                    ics.add(cd);
                }
                continue;
            }
            if (!(imprt instanceof NamespaceImport) || !cd.getNamespaceExports().contains(((NamespaceImport)imprt).getNamespace())) continue;
            ics.add(cd);
        }
        return ics;
    }

    @Override
    public Object getQNameDefinition(String contributionURI, QName definition, QName symbolSpace) {
        return null;
    }

    @Override
    public List<String> startDeployables(String contributionURI) throws ActivationException, ValidationException, ContributionReadException {
        List<String> dcURIs = this.getDeployableCompositeURIs(contributionURI);
        for (String dcURI : dcURIs) {
            this.startComposite(contributionURI, dcURI);
        }
        return dcURIs;
    }

    public DomainRegistry getEndpointRegistry() {
        return this.domainRegistry;
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.extensionPointRegistry;
    }

    @Override
    public void stop() {
        for (DeployedComposite dc : this.startedComposites.values()) {
            try {
                dc.stop();
            }
            catch (ActivationException activationException) {}
        }
        this.startedComposites.clear();
        this.stoppedComposites.clear();
        this.extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(ActiveNodes.class).getActiveNodes().remove(this);
        this.domainRegistry.removeContributionListener(this.contributionListener);
        if (this.tuscanyRuntime != null) {
            this.tuscanyRuntime.stop();
        }
    }

    @Override
    public List<String> getNodeNames() {
        return this.domainRegistry.getNodeNames();
    }

    @Override
    public String getLocalNodeName() {
        return this.domainRegistry.getLocalNodeName();
    }

    @Override
    public String getRunningNodeName(String contributionURI, String compositeURI) {
        return this.domainRegistry.getRunningNodeName(contributionURI, compositeURI);
    }

    public List<String> updateUsingComposites(String contributionURI, String compositeURI) throws ActivationException, ContributionReadException, ValidationException {
        ArrayList<String> updated = new ArrayList<String>();
        for (DeployedComposite dc : new ArrayList<DeployedComposite>(this.startedComposites.values())) {
            if (!dc.uses(contributionURI, compositeURI)) continue;
            String dcContributionURI = dc.getContributionURIs().get(0);
            String dcCompositeURI = dc.getURI();
            this.stopComposite(dcContributionURI, dcCompositeURI);
            String key = dcContributionURI + "/" + dcCompositeURI;
            this.stoppedComposites.remove(key);
            updated.add(key);
            this.startComposite(dcContributionURI, dcCompositeURI);
        }
        if (logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "updateUsingComposites", updated);
        }
        return updated;
    }

    public void uninstallContribution(String contributionURI, boolean b) throws ActivationException {
        this.uninstallContribution(contributionURI);
        if (!b) {
            return;
        }
        for (DeployedComposite dc : new ArrayList<DeployedComposite>(this.startedComposites.values())) {
            if (!dc.getContributionURIs().contains(contributionURI)) continue;
            String dcContributionURI = dc.getContributionURIs().get(0);
            String dcCompositeURI = dc.getURI();
            this.stopComposite(dcContributionURI, dcCompositeURI);
            String key = dcContributionURI + "/" + dcCompositeURI;
            this.stoppedComposites.remove(key);
        }
        for (DeployedComposite dc : new ArrayList<DeployedComposite>(this.stoppedComposites.values())) {
            if (!dc.getContributionURIs().contains(contributionURI)) continue;
            this.stoppedComposites.remove(contributionURI + "/" + dc.getURI());
        }
    }

    public boolean getEndpointsIncludeDomainName() {
        return this.endpointsIncludeDomainName;
    }

    public void setEndpointsIncludeDomainName(boolean b) {
        this.endpointsIncludeDomainName = b;
    }
}

