/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.webapp.WebAppHelper;
import org.apache.tuscany.sca.host.webapp.WebContextConfigurator;

public class TuscanyServletFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(TuscanyServletFilter.class.getName());
    private transient WebContextConfigurator configurator;
    private transient ServletHost servletHost;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.configurator = WebAppHelper.getConfigurator(config);
            WebAppHelper.init(this.configurator);
            this.servletHost = WebAppHelper.getServletHost();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.configurator.getServletContext().log(e.getMessage(), e);
            throw new ServletException(e);
        }
    }

    public void destroy() {
        WebAppHelper.stop(this.configurator);
        this.servletHost = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            RequestDispatcher dispatcher;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String path = httpRequest.getPathInfo();
            if (path == null) {
                path = httpRequest.getServletPath();
            }
            if (path == null) {
                path = "/";
            }
            if ((dispatcher = this.servletHost.getRequestDispatcher(path)) != null) {
                dispatcher.forward(request, response);
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.configurator.getServletContext().log(e.getMessage(), e);
            throw new ServletException(e);
        }
    }
}

