/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletMappingException;

public class DefaultServletHostExtensionPoint
implements ServletHostExtensionPoint,
LifeCycleListener {
    private List<ServletHost> servletHosts = new ArrayList<ServletHost>();
    private boolean loaded;
    private boolean webApp;
    private ExtensionPointRegistry registry;

    public DefaultServletHostExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addServletHost(ServletHost servletHost) {
        this.servletHosts.add(servletHost);
        if (servletHost instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)servletHost)).start();
        }
    }

    @Override
    public void removeServletHost(ServletHost servletHost) {
        this.servletHosts.remove(servletHost);
        if (servletHost instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)servletHost)).stop();
        }
    }

    @Override
    public List<ServletHost> getServletHosts() {
        this.loadServletHosts();
        return this.servletHosts;
    }

    private synchronized void loadServletHosts() {
        Collection<ServiceDeclaration> sds;
        if (this.loaded) {
            return;
        }
        try {
            sds = this.registry.getServiceDiscovery().getServiceDeclarations(ServletHost.class, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration sd : sds) {
            LazyServletHost servletHost = new LazyServletHost(sd);
            this.addServletHost(servletHost);
        }
        this.loaded = true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        ServiceHelper.stop(this.servletHosts);
        this.servletHosts.clear();
        this.registry = null;
    }

    @Override
    public boolean isWebApp() {
        return this.webApp;
    }

    @Override
    public void setWebApp(boolean webApp) {
        this.webApp = webApp;
    }

    public class LazyServletHost
    implements ServletHost,
    LifeCycleListener {
        private ServiceDeclaration sd;
        private ServletHost host;

        public LazyServletHost(ServiceDeclaration sd) {
            this.sd = sd;
        }

        public synchronized ServletHost getServletHost() {
            if (this.host == null) {
                try {
                    this.host = (ServletHost)ServiceHelper.newInstance(DefaultServletHostExtensionPoint.this.registry, this.sd);
                    ServiceHelper.start(this.host);
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.host;
        }

        @Override
        public String addServletMapping(String uri, Servlet servlet) throws ServletMappingException {
            return this.getServletHost().addServletMapping(uri, servlet);
        }

        @Override
        public String addServletMapping(String uri, Servlet servlet, SecurityContext securityContext) throws ServletMappingException {
            return this.getServletHost().addServletMapping(uri, servlet, securityContext);
        }

        @Override
        public String getContextPath() {
            return this.getServletHost().getContextPath();
        }

        @Override
        public int getDefaultPort() {
            return this.getServletHost().getDefaultPort();
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String uri) throws ServletMappingException {
            return this.getServletHost().getRequestDispatcher(uri);
        }

        @Override
        public Servlet getServletMapping(String uri) throws ServletMappingException {
            return this.getServletHost().getServletMapping(uri);
        }

        @Override
        public URL getURLMapping(String uri, SecurityContext securityContext) {
            return this.getServletHost().getURLMapping(uri, securityContext);
        }

        @Override
        public Servlet removeServletMapping(String uri) throws ServletMappingException {
            return this.getServletHost().removeServletMapping(uri);
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.getServletHost().setAttribute(name, value);
        }

        @Override
        public void setContextPath(String path) {
            this.getServletHost().setContextPath(path);
        }

        @Override
        public void setDefaultPort(int port) {
            this.getServletHost().setDefaultPort(port);
        }

        @Override
        public String getName() {
            return this.sd.getAttributes().get("name");
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            ServiceHelper.stop(this.host);
        }

        @Override
        public ServletContext getServletContext() {
            return this.getServletHost().getServletContext();
        }
    }
}

