/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.xml.XMLStringDataBinding;

public class String2JAXB
extends BaseTransformer<String, Object>
implements PullTransformer<String, Object> {
    private JAXBContextHelper contextHelper;

    public String2JAXB(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object transform(String source, TransformationContext context) {
        if (source == null) {
            return null;
        }
        JAXBContext jaxbContext = this.contextHelper.createJAXBContext(context, false);
        StreamSource streamSource = new StreamSource(new StringReader(source));
        Unmarshaller unmarshaller = this.contextHelper.getUnmarshaller(jaxbContext);
        try {
            JAXBElement result = unmarshaller.unmarshal((Source)streamSource, JAXBContextHelper.getJavaType(context.getTargetDataType()));
            Object object = JAXBContextHelper.createReturnValue(jaxbContext, context.getTargetDataType(), result);
            this.contextHelper.releaseJAXBUnmarshaller(jaxbContext, unmarshaller);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.contextHelper.releaseJAXBUnmarshaller(jaxbContext, unmarshaller);
                throw throwable;
            }
            catch (Exception e) {
                throw new TransformationException(e);
            }
        }
    }

    @Override
    protected Class<String> getSourceType() {
        return String.class;
    }

    @Override
    protected Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public int getWeight() {
        return 30;
    }

    @Override
    public String getSourceDataBinding() {
        return XMLStringDataBinding.NAME;
    }

    @Override
    public String getTargetDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

