/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.common.java.collection.LRUCache;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextCache;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public final class JAXBContextHelper {
    private final JAXBContextCache cache;
    private static final SimpleTypeMapper SIMPLE_TYPE_MAPPER = new SimpleTypeMapperImpl();

    public JAXBContextHelper(ExtensionPointRegistry registry) {
        this.cache = new JAXBContextCache(registry);
    }

    public static JAXBContextHelper getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilityExtensionPoint = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilityExtensionPoint.getUtility(JAXBContextHelper.class);
    }

    public JAXBContext createJAXBContext(Class<?> cls) throws JAXBException {
        return this.cache.getJAXBContext(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext createJAXBContext(TransformationContext tContext, boolean source) throws JAXBException {
        Operation op;
        if (tContext == null) {
            throw new TransformationException("JAXB context is not set for the transformation.");
        }
        Operation operation = op = source ? tContext.getSourceOperation() : tContext.getTargetOperation();
        if (op != null) {
            Operation operation2 = op;
            synchronized (operation2) {
                JAXBContext context = op.getInputType().getMetaData(JAXBContext.class);
                if (context == null) {
                    context = this.createJAXBContext(JAXBContextHelper.getDataTypes(op, true));
                    op.getInputType().setMetaData(JAXBContext.class, context);
                }
                return context;
            }
        }
        DataType dataType = source ? tContext.getSourceDataType() : tContext.getTargetDataType();
        return this.createJAXBContext(dataType);
    }

    private static Class<?>[] getSeeAlso(Class<?> interfaze) {
        if (interfaze == null) {
            return null;
        }
        XmlSeeAlso seeAlso = interfaze.getAnnotation(XmlSeeAlso.class);
        if (seeAlso == null) {
            return null;
        }
        return seeAlso.value();
    }

    public JAXBContext createJAXBContext(DataType dataType) throws JAXBException {
        return this.createJAXBContext(JAXBContextHelper.findClasses(dataType));
    }

    public Unmarshaller getUnmarshaller(JAXBContext context) throws JAXBException {
        return this.cache.getUnmarshaller(context);
    }

    public void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        this.cache.releaseJAXBUnmarshaller(context, unmarshaller);
    }

    public Marshaller getMarshaller(JAXBContext context) throws JAXBException {
        return this.cache.getMarshaller(context);
    }

    public void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        this.cache.releaseJAXBMarshaller(context, marshaller);
    }

    public static Object createJAXBElement(JAXBContext context, DataType dataType, Object value) {
        Class<Object> type = dataType == null ? value.getClass() : dataType.getPhysical();
        type = JAXBContextHelper.getValueType(type);
        QName name = JAXBDataBinding.ROOT_ELEMENT;
        if (context != null) {
            Object logical;
            Object v0 = logical = dataType == null ? null : dataType.getLogical();
            if (logical instanceof XMLType) {
                XMLType xmlType = logical;
                if (xmlType.isElement()) {
                    name = xmlType.getElementName();
                } else {
                    type = Object.class;
                }
            } else {
                type = Object.class;
            }
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        Object element = null;
        if (value != null && introspector.isElement(value)) {
            element = value;
        }
        if (element == null) {
            element = new JAXBElement(name, Object.class, value);
        }
        return element;
    }

    public static Object createReturnValue(JAXBContext context, DataType dataType, Object value) {
        Class<?> cls = JAXBContextHelper.getJavaType(dataType);
        if (cls == JAXBElement.class) {
            return JAXBContextHelper.createJAXBElement(context, dataType, value);
        }
        if (value instanceof JAXBElement) {
            Object returnValue = ((JAXBElement)value).getValue();
            if (returnValue == null) {
                throw new TransformationException("Null returned when trying to convert value to: " + cls.getName());
            }
            return returnValue;
        }
        return value;
    }

    public JAXBContext createJAXBContext(Class<?>[] classes) throws JAXBException {
        return this.cache.getJAXBContext(classes);
    }

    public JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        return this.cache.getJAXBContext(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext createJAXBContext(Interface intf, boolean useWrapper) throws JAXBException {
        JAXBContextCache jAXBContextCache = this.cache;
        synchronized (jAXBContextCache) {
            LRUCache<Object, JAXBContext> map = this.cache.getCache();
            Integer key = new Integer(System.identityHashCode(intf));
            JAXBContext context = (JAXBContext)map.get(key);
            if (context != null) {
                return context;
            }
            List<DataType> dataTypes = JAXBContextHelper.getDataTypes(intf, useWrapper);
            context = this.createJAXBContext(dataTypes);
            map.put(key, context);
            return context;
        }
    }

    public JAXBContext createJAXBContext(List<DataType> dataTypes) throws JAXBException {
        HashSet classes = new HashSet();
        HashSet<Type> visited = new HashSet<Type>();
        for (DataType d : dataTypes) {
            JAXBContextHelper.findClasses(d, classes, visited);
        }
        JAXBContext context = this.createJAXBContext(classes);
        return context;
    }

    private static Set<Class<?>> findClasses(DataType d) {
        HashSet classes = new HashSet();
        HashSet<Type> visited = new HashSet<Type>();
        JAXBContextHelper.findClasses(d, classes, visited);
        return classes;
    }

    private static void findClasses(DataType d, Set<Class<?>> classes, Set<Type> visited) {
        if (d == null) {
            return;
        }
        String db = d.getDataBinding();
        if (JAXBDataBinding.NAME.equals(db) || db != null && db.startsWith("java:") || db == null) {
            if (!d.getPhysical().isInterface() && !JAXBElement.class.isAssignableFrom(d.getPhysical())) {
                classes.add(d.getPhysical());
            } else {
                classes.addAll(JAXBContextHelper.findJAXBClassesByInterface(d.getPhysical()));
            }
        }
        if (d.getPhysical() != d.getGenericType()) {
            JAXBContextHelper.findClasses(d.getGenericType(), classes, visited);
        }
    }

    private static void findClasses(Type type, Set<Class<?>> classSet, Set<Type> visited) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (visited.contains(type) || type == null) {
                            return;
                        }
                        visited.add(type);
                        if (type instanceof Class) {
                            Class cls = (Class)type;
                            if (!cls.isInterface()) {
                                classSet.add(cls);
                            } else {
                                classSet.addAll(JAXBContextHelper.findJAXBClassesByInterface(cls));
                            }
                            return;
                        }
                        if (!(type instanceof ParameterizedType)) break block8;
                        ParameterizedType pType = (ParameterizedType)type;
                        JAXBContextHelper.findClasses(pType.getRawType(), classSet, visited);
                        for (Type t : pType.getActualTypeArguments()) {
                            JAXBContextHelper.findClasses(t, classSet, visited);
                        }
                        break block9;
                    }
                    if (!(type instanceof TypeVariable)) break block10;
                    TypeVariable tv = (TypeVariable)type;
                    for (Type t : tv.getBounds()) {
                        JAXBContextHelper.findClasses(t, classSet, visited);
                    }
                    break block9;
                }
                if (!(type instanceof GenericArrayType)) break block11;
                GenericArrayType gType = (GenericArrayType)type;
                JAXBContextHelper.findClasses(gType.getGenericComponentType(), classSet, visited);
                break block9;
            }
            if (!(type instanceof WildcardType)) break block9;
            WildcardType wType = (WildcardType)type;
            for (Type t : wType.getLowerBounds()) {
                JAXBContextHelper.findClasses(t, classSet, visited);
            }
            for (Type t : wType.getUpperBounds()) {
                JAXBContextHelper.findClasses(t, classSet, visited);
            }
        }
    }

    private static Set<Class<?>> findJAXBClassesByInterface(Class<?> cls) {
        XmlJavaTypeAdapters adapters;
        Package pkg;
        Class<?>[] others;
        if (!cls.isInterface()) {
            return Collections.emptySet();
        }
        HashSet jaxbClasses = new HashSet();
        Class<?> valueType = JAXBContextHelper.getValueType(cls);
        if (valueType != null) {
            jaxbClasses.add(valueType);
        }
        if ((others = JAXBContextHelper.getSeeAlso(cls)) != null) {
            jaxbClasses.addAll(Arrays.asList(others));
        }
        if ((pkg = cls.getPackage()) != null && (adapters = pkg.getAnnotation(XmlJavaTypeAdapters.class)) != null) {
            for (XmlJavaTypeAdapter a : adapters.value()) {
                jaxbClasses.add(JAXBContextHelper.getValueType(a));
            }
        }
        return jaxbClasses;
    }

    public static Class<?> getValueType(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (cls.isInterface()) {
            XmlJavaTypeAdapter adapter = cls.getAnnotation(XmlJavaTypeAdapter.class);
            return JAXBContextHelper.getValueType(adapter);
        }
        return cls;
    }

    private static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            return 0 < bounds.length ? JAXBContextHelper.erase(bounds[0]) : Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] bounds = wt.getUpperBounds();
            return 0 < bounds.length ? JAXBContextHelper.erase(bounds[0]) : Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Array.newInstance(JAXBContextHelper.erase(gat.getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Unknown Type kind: " + type.getClass());
    }

    public static Class<?> getValueType(XmlJavaTypeAdapter adapter) {
        Class adapterClass;
        if (adapter != null && (adapterClass = adapter.value()) != null) {
            Type superClass = adapterClass.getGenericSuperclass();
            while (superClass instanceof ParameterizedType && XmlAdapter.class != ((ParameterizedType)superClass).getRawType()) {
                superClass = JAXBContextHelper.erase(superClass).getGenericSuperclass();
            }
            return JAXBContextHelper.erase(((ParameterizedType)superClass).getActualTypeArguments()[0]);
        }
        return null;
    }

    public JAXBContext createJAXBContext(Interface intf) throws JAXBException {
        return this.createJAXBContext(intf, true);
    }

    private static List<DataType> getDataTypes(Interface intf, boolean useWrapper) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Operation op : intf.getOperations()) {
            JAXBContextHelper.getDataTypes(dataTypes, op, useWrapper);
        }
        return dataTypes;
    }

    private static List<DataType> getDataTypes(Operation op, boolean useWrapper) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        JAXBContextHelper.getDataTypes(dataTypes, op, useWrapper);
        Interface interface1 = op.getInterface();
        if (interface1 instanceof JavaInterface) {
            JavaInterface javaInterface = (JavaInterface)interface1;
            Class<?>[] seeAlso = JAXBContextHelper.getSeeAlso(javaInterface.getJavaClass());
            if (seeAlso != null) {
                for (Class<?> cls : seeAlso) {
                    dataTypes.add(new DataTypeImpl<XMLType>(JAXBDataBinding.NAME, cls, XMLType.UNKNOWN));
                }
            }
            if ((seeAlso = JAXBContextHelper.getSeeAlso(javaInterface.getCallbackClass())) != null) {
                for (Class<?> cls : seeAlso) {
                    dataTypes.add(new DataTypeImpl<XMLType>(JAXBDataBinding.NAME, cls, XMLType.UNKNOWN));
                }
            }
        }
        return dataTypes;
    }

    private static void getDataTypes(List<DataType> dataTypes, Operation op, boolean useWrapper) {
        DataType<XMLType> dt2;
        DataType<XMLType> dt1;
        WrapperInfo inputWrapper = op.getInputWrapper();
        WrapperInfo outputWrapper = op.getOutputWrapper();
        if (useWrapper && inputWrapper != null && (dt1 = inputWrapper.getWrapperType()) != null) {
            dataTypes.add(dt1);
        }
        if (useWrapper && outputWrapper != null && (dt2 = outputWrapper.getWrapperType()) != null) {
            dataTypes.add(dt2);
        }
        for (DataType dt12 : op.getInputType().getLogical()) {
            dataTypes.add(dt12);
        }
        for (DataType dt22 : op.getOutputType().getLogical()) {
            dataTypes.add(dt22);
        }
        for (DataType dt3 : op.getFaultTypes()) {
            DataType dt4 = (DataType)dt3.getLogical();
            if (dt4 == null) continue;
            dataTypes.add(dt4);
        }
    }

    public static Class<?> getJavaType(DataType<?> dataType) {
        XMLType xType;
        Class<?> javaType;
        if (dataType == null) {
            return null;
        }
        Class<Object> type = dataType.getPhysical();
        if (JAXBElement.class.isAssignableFrom(type)) {
            Type generic = dataType.getGenericType();
            type = Object.class;
        }
        if (type == Object.class && dataType.getLogical() instanceof XMLType && (javaType = SIMPLE_TYPE_MAPPER.getJavaType((xType = (XMLType)dataType.getLogical()).getTypeName())) != null) {
            type = javaType;
        }
        return type;
    }

    public static XMLType getXmlTypeName(Class<?> javaType) {
        XmlType type;
        XmlSchema schema;
        if (javaType.isInterface()) {
            return null;
        }
        String namespace = null;
        String name = null;
        Package pkg = javaType.getPackage();
        if (pkg != null && (schema = pkg.getAnnotation(XmlSchema.class)) != null) {
            namespace = schema.namespace();
        }
        QName elementQName = null;
        QName typeQName = null;
        XmlRootElement rootElement = javaType.getAnnotation(XmlRootElement.class);
        if (rootElement != null) {
            String elementName = rootElement.name();
            String elementNamespace = rootElement.namespace();
            if (elementNamespace.equals("##default")) {
                elementNamespace = namespace;
            }
            if (elementName.equals("##default")) {
                elementName = JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName());
            }
            elementQName = new QName(elementNamespace, elementName);
        }
        if ((type = javaType.getAnnotation(XmlType.class)) != null) {
            String typeNamespace = type.namespace();
            String typeName = type.name();
            if (typeNamespace.equals("##default")) {
                typeNamespace = namespace;
            }
            if (typeName.equals("##default")) {
                typeName = JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName());
            }
            typeQName = new QName(typeNamespace, typeName);
        } else {
            XmlEnum xmlEnum = javaType.getAnnotation(XmlEnum.class);
            if (xmlEnum != null || namespace != null) {
                name = JAXBContextHelper.jaxbDecapitalize(javaType.getSimpleName());
                typeQName = new QName(namespace, name);
            }
        }
        if (elementQName == null && typeQName == null) {
            return null;
        }
        return new XMLType(elementQName, typeQName);
    }

    public static String jaxbDecapitalize(String name) {
        int lower = name.length();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLowerCase(name.charAt(i))) continue;
            lower = i;
            break;
        }
        int decap = name.length() == 0 ? 0 : (lower == 0 ? 0 : (lower == 1 ? 1 : (lower < name.length() ? lower - 1 : name.length())));
        return name.substring(0, decap).toLowerCase() + name.substring(decap);
    }

    public void removeJAXBContextForContribution(ClassLoader contributionClassloader) {
        this.cache.removeJAXBContextForContribution(contributionClassloader);
    }

    public JAXBContextCache getJAXBContextCache() {
        return this.cache;
    }
}

