/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.xml.XMLStringDataBinding;

public class JAXB2String
extends BaseTransformer<Object, String>
implements PullTransformer<Object, String> {
    private JAXBContextHelper contextHelper;

    public JAXB2String(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transform(Object source, TransformationContext tContext) {
        try {
            JAXBContext context = this.contextHelper.createJAXBContext(tContext, true);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Object jaxbElement = JAXBContextHelper.createJAXBElement(context, tContext.getSourceDataType(), source);
            Marshaller marshaller = this.contextHelper.getMarshaller(context);
            try {
                marshaller.marshal(jaxbElement, (Result)result);
            }
            finally {
                this.contextHelper.releaseJAXBMarshaller(context, marshaller);
            }
            return writer.toString();
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    protected Class<String> getTargetType() {
        return String.class;
    }

    @Override
    public int getWeight() {
        return 30;
    }

    @Override
    public String getSourceDataBinding() {
        return JAXBDataBinding.NAME;
    }

    @Override
    public String getTargetDataBinding() {
        return XMLStringDataBinding.NAME;
    }
}

