/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.impl.JDKProxyFactory;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;

public class DefaultProxyFactoryExtensionPoint
implements ProxyFactoryExtensionPoint,
LifeCycleListener {
    private InterfaceContractMapper interfaceContractMapper;
    private MessageFactory messageFactory;
    private ProxyFactory interfaceFactory;
    private ProxyFactory classFactory;

    public DefaultProxyFactoryExtensionPoint(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = modelFactories.getFactory(MessageFactory.class);
        this.interfaceFactory = new JDKProxyFactory(registry, this.messageFactory, this.interfaceContractMapper);
    }

    @Override
    public ProxyFactory getClassProxyFactory() {
        return this.classFactory;
    }

    @Override
    public ProxyFactory getInterfaceProxyFactory() {
        return this.interfaceFactory;
    }

    @Override
    public void setClassProxyFactory(ProxyFactory factory) {
        this.classFactory = factory;
    }

    @Override
    public void setInterfaceProxyFactory(ProxyFactory factory) {
        this.interfaceFactory = factory;
    }

    @Override
    public void start() {
        if (this.interfaceFactory instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)this.interfaceFactory)).start();
        }
        if (this.classFactory instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)this.classFactory)).start();
        }
    }

    @Override
    public void stop() {
        if (this.interfaceFactory instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)this.interfaceFactory)).stop();
        }
        if (this.classFactory instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)this.classFactory)).stop();
        }
    }
}

