/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.Method;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.tuscany.sca.core.context.ServiceReferenceExt;
import org.apache.tuscany.sca.core.context.impl.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ProxyCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.impl.JDKCallbackInvocationHandler;
import org.apache.tuscany.sca.core.invocation.impl.JDKInvocationHandler;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceReference;

public class CglibProxyFactory
implements ProxyFactory {
    private MessageFactory messageFactory;

    public CglibProxyFactory(MessageFactory messageFactory, InterfaceContractMapper mapper) {
        this.messageFactory = messageFactory;
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, Invocable invocable) throws ProxyCreationException {
        if (invocable instanceof RuntimeEndpoint) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(interfaze);
            enhancer.setCallback(new CglibMethodInterceptor(interfaze, invocable));
            Object proxy = enhancer.create();
            return interfaze.cast(proxy);
        }
        ServiceReferenceImpl<T> serviceReference = new ServiceReferenceImpl<T>(interfaze, invocable, null);
        return this.createProxy(serviceReference);
    }

    @Override
    public <T> T createProxy(ServiceReference<T> callableReference) throws ProxyCreationException {
        Enhancer enhancer = new Enhancer();
        Class<T> interfaze = callableReference.getBusinessInterface();
        enhancer.setSuperclass(interfaze);
        enhancer.setCallback(new CglibMethodInterceptor<T>(callableReference));
        Object proxy = enhancer.create();
        ((ServiceReferenceImpl)callableReference).setProxy(proxy);
        return interfaze.cast(proxy);
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, List<? extends Invocable> wires) throws ProxyCreationException {
        ServiceReferenceImpl<T> callbackReference = new ServiceReferenceImpl<T>(interfaze, wires.get(0), null);
        return callbackReference != null ? (T)this.createCallbackProxy(callbackReference) : null;
    }

    @Override
    public <T> T createCallbackProxy(ServiceReference<T> callbackReference) throws ProxyCreationException {
        Enhancer enhancer = new Enhancer();
        Class<T> interfaze = callbackReference.getBusinessInterface();
        enhancer.setSuperclass(interfaze);
        enhancer.setCallback(new CglibMethodInterceptor<T>(callbackReference));
        Object object = enhancer.create();
        T proxy = interfaze.cast(object);
        ((ServiceReferenceExt)callbackReference).setProxy(proxy);
        return proxy;
    }

    @Override
    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        if (this.isProxyClass(target.getClass())) {
            Factory factory = (Factory)target;
            Callback[] callbacks = factory.getCallbacks();
            if (callbacks.length != 1 || !(callbacks[0] instanceof CglibMethodInterceptor)) {
                throw new IllegalArgumentException("The object is not a known proxy.");
            }
            CglibMethodInterceptor interceptor = (CglibMethodInterceptor)callbacks[0];
            return (R)interceptor.invocationHandler.getCallableReference();
        }
        throw new IllegalArgumentException("The object is not a known proxy.");
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        return Factory.class.isAssignableFrom(clazz);
    }

    @Override
    public void removeProxiesForContribution(ClassLoader contributionClassloader) {
    }

    private class CglibMethodInterceptor<T>
    implements MethodInterceptor {
        private JDKInvocationHandler invocationHandler;

        public CglibMethodInterceptor(ServiceReference<T> callableReference) {
            this.invocationHandler = new JDKInvocationHandler(CglibProxyFactory.this.messageFactory, callableReference);
        }

        public CglibMethodInterceptor(Class<?> interfaze, Invocable invocable) {
            this.invocationHandler = new JDKInvocationHandler(CglibProxyFactory.this.messageFactory, interfaze, invocable);
        }

        public CglibMethodInterceptor(ServiceReferenceImpl<T> callbackReference) {
            this.invocationHandler = new JDKCallbackInvocationHandler(CglibProxyFactory.this.messageFactory, callbackReference);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object result = this.invocationHandler.invoke(proxy, method, args);
            return result;
        }
    }
}

