/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;

public class DefaultUtilityExtensionPoint
implements UtilityExtensionPoint {
    private Map<Object, Object> utilities = new ConcurrentHashMap<Object, Object>();
    private ExtensionPointRegistry registry;

    public DefaultUtilityExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.registry = extensionPoints;
    }

    @Override
    public void addUtility(Object utility) {
        this.addUtility(null, utility);
    }

    @Override
    public void addUtility(Object key, Object utility) {
        if (utility == null) {
            throw new IllegalArgumentException("Cannot register null as a Service");
        }
        if (utility instanceof LifeCycleListener) {
            ((LifeCycleListener)utility).start();
        }
        if (key == null) {
            Class<?> cls = utility.getClass();
            Set<Class<?>> interfaces = DefaultUtilityExtensionPoint.getAllInterfaces(cls);
            for (Class<?> i : interfaces) {
                this.utilities.put(i, utility);
            }
            if (interfaces.isEmpty() || this.isConcreteClass(cls)) {
                this.utilities.put(cls, utility);
            }
        } else {
            this.utilities.put(key, utility);
        }
    }

    @Override
    public <T> T getUtility(Class<T> utilityType) {
        return this.getUtility(utilityType, null);
    }

    @Override
    public void removeUtility(Object utility) {
        if (utility == null) {
            throw new IllegalArgumentException("Cannot remove null as a Service");
        }
        if (utility instanceof LifeCycleListener) {
            ((LifeCycleListener)utility).stop();
        }
        Iterator<Map.Entry<Object, Object>> i = this.utilities.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            if (entry.getValue() != utility) continue;
            i.remove();
        }
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet implemented = new HashSet();
        DefaultUtilityExtensionPoint.getAllInterfaces(clazz, implemented);
        implemented.remove(LifeCycleListener.class);
        return implemented;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> implemented) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            if (!Modifier.isPublic(interfaze.getModifiers())) continue;
            implemented.add(interfaze);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            DefaultUtilityExtensionPoint.getAllInterfaces(superClass, implemented);
        }
    }

    @Override
    public <T> T getUtility(Class<T> utilityType, Object key) {
        Object utility;
        block14: {
            if (utilityType == null) {
                throw new IllegalArgumentException("Cannot lookup Service of type null");
            }
            if (key == null) {
                key = utilityType;
            }
            if ((utility = this.utilities.get(key)) == null) {
                try {
                    ServiceDeclaration utilityDeclaration = this.registry.getServiceDiscovery().getServiceDeclaration(utilityType.getName());
                    Class<Object> utilityClass = null;
                    if (utilityDeclaration != null) {
                        utilityClass = utilityDeclaration.loadClass();
                    } else if (this.isConcreteClass(utilityType)) {
                        utilityClass = utilityType;
                        key = utilityType;
                    }
                    if (utilityClass == null) break block14;
                    if (utilityDeclaration != null) {
                        utility = ServiceHelper.newInstance(this.registry, utilityDeclaration);
                    } else {
                        try {
                            utility = ServiceHelper.newInstance(utilityClass, ExtensionPointRegistry.class, (Object)this.registry);
                        }
                        catch (NoSuchMethodException e) {
                            utility = ServiceHelper.newInstance(utilityClass);
                        }
                    }
                    if (key == utilityType) {
                        this.addUtility(utility);
                    } else {
                        this.addUtility(key, utility);
                    }
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return utilityType.cast(utility);
    }

    private boolean isConcreteClass(Class<?> utilityType) {
        int modifiers = utilityType.getModifiers();
        return !utilityType.isInterface() && Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        IdentityHashMap<LifeCycleListener, LifeCycleListener> map = new IdentityHashMap<LifeCycleListener, LifeCycleListener>();
        for (Object util : this.utilities.values()) {
            if (!(util instanceof LifeCycleListener)) continue;
            LifeCycleListener listener = (LifeCycleListener)util;
            map.put(listener, listener);
        }
        for (LifeCycleListener listener : map.values()) {
            listener.stop();
        }
        this.utilities.clear();
    }
}

