/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistryLocator;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.extensibility.ServiceHelper;

public class DefaultExtensionPointRegistry
implements ExtensionPointRegistry {
    protected Map<Class<?>, Object> extensionPoints = new HashMap();
    private ServiceDiscovery discovery;

    public DefaultExtensionPointRegistry() {
        this.discovery = ServiceDiscovery.getInstance();
    }

    public DefaultExtensionPointRegistry(ServiceDiscovery discovery) {
        this.discovery = discovery;
    }

    @Override
    public synchronized void addExtensionPoint(Object extensionPoint) {
        this.addExtensionPoint(extensionPoint, null);
    }

    public synchronized void addExtensionPoint(Object extensionPoint, ServiceDeclaration declaration) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Cannot register null as an ExtensionPoint");
        }
        ServiceHelper.start(extensionPoint);
        Set<Class<?>> interfaces = DefaultExtensionPointRegistry.getAllInterfaces(extensionPoint.getClass());
        for (Class<?> i : interfaces) {
            this.registerExtensionPoint(i, extensionPoint, declaration);
        }
    }

    protected void registerExtensionPoint(Class<?> i, Object extensionPoint, ServiceDeclaration declaration) {
        this.extensionPoints.put(i, extensionPoint);
    }

    @Override
    public synchronized <T> T getExtensionPoint(Class<T> extensionPointType) {
        if (extensionPointType == null) {
            throw new IllegalArgumentException("Cannot lookup ExtensionPoint of type null");
        }
        Object extensionPoint = this.findExtensionPoint(extensionPointType);
        if (extensionPoint == null) {
            try {
                ServiceDeclaration extensionPointDeclaration = this.getServiceDiscovery().getServiceDeclaration(extensionPointType);
                if (extensionPointDeclaration != null) {
                    extensionPoint = ServiceHelper.newInstance(this, extensionPointDeclaration);
                    this.addExtensionPoint(extensionPoint, extensionPointDeclaration);
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return extensionPointType.cast(extensionPoint);
    }

    protected <T> Object findExtensionPoint(Class<T> extensionPointType) {
        return this.extensionPoints.get(extensionPointType);
    }

    @Override
    public synchronized void removeExtensionPoint(Object extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Cannot remove null as an ExtensionPoint");
        }
        ServiceHelper.stop(extensionPoint);
        Set<Class<?>> interfaces = DefaultExtensionPointRegistry.getAllInterfaces(extensionPoint.getClass());
        for (Class<?> i : interfaces) {
            this.unregisterExtensionPoint(i);
        }
    }

    protected void unregisterExtensionPoint(Class<?> i) {
        this.extensionPoints.remove(i);
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet implemented = new HashSet();
        DefaultExtensionPointRegistry.getAllInterfaces(clazz, implemented);
        implemented.remove(LifeCycleListener.class);
        return implemented;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> implemented) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            if (!Modifier.isPublic(interfaze.getModifiers())) continue;
            implemented.add(interfaze);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            DefaultExtensionPointRegistry.getAllInterfaces(superClass, implemented);
        }
    }

    @Override
    public synchronized void start() {
        ExtensionPointRegistryLocator.addExtensionPointRegistry(this);
    }

    @Override
    public synchronized void stop() {
        IdentityHashMap<LifeCycleListener, LifeCycleListener> map = new IdentityHashMap<LifeCycleListener, LifeCycleListener>();
        for (Object extp : this.extensionPoints.values()) {
            if (!(extp instanceof LifeCycleListener)) continue;
            LifeCycleListener listener = (LifeCycleListener)extp;
            map.put(listener, listener);
        }
        ServiceHelper.stop(map.values());
        this.extensionPoints.clear();
        ExtensionPointRegistryLocator.removeExtensionPointRegistry(this);
    }

    @Override
    public ServiceDiscovery getServiceDiscovery() {
        return this.discovery;
    }
}

