/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class AnyElementProcessor
implements StAXArtifactProcessor<Extension> {
    private AssemblyFactory assemblyFactory;
    private StAXHelper helper;

    public AnyElementProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor) {
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.helper = StAXHelper.getInstance(extensionPoints);
    }

    @Override
    public QName getArtifactType() {
        return ExtensibleStAXArtifactProcessor.ANY_ELEMENT;
    }

    @Override
    public Class<Extension> getModelType() {
        return Extension.class;
    }

    @Override
    public Extension read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        QName name = reader.getName();
        String xml = this.helper.saveAsString(reader);
        Extension ext = this.assemblyFactory.createExtension();
        ext.setQName(name);
        ext.setValue(xml);
        return ext;
    }

    @Override
    public void write(Extension model, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException {
        Object value = model.getValue();
        if (!(value instanceof String)) {
            return;
        }
        String xml = (String)value;
        XMLStreamReader reader = this.helper.createXMLStreamReader(new StringReader(xml));
        reader.nextTag();
        this.helper.save(reader, writer);
    }

    @Override
    public void resolve(Extension model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

