/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;

public final class ThreadMessageContext {
    private static final Message msg = new Message(){
        private Map<String, Object> headers = new HashMap<String, Object>();

        @Override
        public void setTo(Endpoint to) {
        }

        @Override
        public void setOperation(Operation op) {
        }

        @Override
        public void setMessageID(Object messageId) {
        }

        @Override
        public void setFrom(EndpointReference from) {
        }

        @Override
        public <T> void setFaultBody(T fault) {
        }

        @Override
        public <T> void setBody(T body) {
        }

        @Override
        public <T> void setBindingContext(T bindingContext) {
        }

        @Override
        public boolean isFault() {
            return false;
        }

        @Override
        public Endpoint getTo() {
            return null;
        }

        @Override
        public Operation getOperation() {
            return null;
        }

        @Override
        public Object getMessageID() {
            return null;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public EndpointReference getFrom() {
            return null;
        }

        @Override
        public <T> T getBody() {
            return null;
        }

        @Override
        public <T> T getBindingContext() {
            return null;
        }
    };
    private static final ThreadLocal<Message> CONTEXT = new ThreadLocal<Message>(){

        @Override
        protected synchronized Message initialValue() {
            return msg;
        }
    };
    private static final ThreadLocal<Message> PREVIOUS_CONTEXT = new ThreadLocal();

    private ThreadMessageContext() {
    }

    public static Message setMessageContext(Message context) {
        Message old = CONTEXT.get();
        CONTEXT.set(context);
        PREVIOUS_CONTEXT.set(old);
        if (context == msg) {
            ThreadMessageContext.removeMessageContext();
            ThreadMessageContext.removePreviousMessageContext();
        }
        return old;
    }

    public static Message getMessageContext() {
        return CONTEXT.get();
    }

    public static Message getPreviousMessageContext() {
        return PREVIOUS_CONTEXT.get();
    }

    public static void removeMessageContext() {
        CONTEXT.remove();
    }

    public static void removePreviousMessageContext() {
        PREVIOUS_CONTEXT.set(null);
    }
}

