/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.xpath;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tuscany.sca.common.xml.stax.reader.NamespaceContextImpl;
import org.apache.tuscany.sca.common.xml.xpath.XMLCharHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;

public class XPathHelper {
    private XPathFactory factory;

    public XPathHelper(XPathFactory factory) {
        this.factory = factory;
    }

    public XPathHelper(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.factory = factories.getFactory(XPathFactory.class);
    }

    public static XPathHelper getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilities.getUtility(XPathHelper.class);
    }

    public XPath newXPath() {
        return this.factory.newXPath();
    }

    public XPathExpression compile(NamespaceContext context, String expression) throws XPathExpressionException {
        XPath path = this.newXPath();
        context = this.getNamespaceContext(expression, context);
        return this.compile(path, context, expression);
    }

    public XPathExpression compile(XPath path, NamespaceContext context, String expression) throws XPathExpressionException {
        path.setNamespaceContext(context);
        return path.compile(expression);
    }

    public NamespaceContext getNamespaceContext(String expression, NamespaceContext context) {
        NamespaceContextImpl nsContext = new NamespaceContextImpl(null);
        boolean found = false;
        for (String prefix : this.getPrefixes(expression)) {
            String namespace = context.getNamespaceURI(prefix);
            if (namespace == null || "".equals(namespace)) continue;
            nsContext.register(prefix, namespace);
            if (!namespace.equals("http://docs.oasis-open.org/ns/opencsa/sca/200912") || prefix.equals("")) continue;
            found = true;
        }
        if (!found) {
            nsContext.register("__sca", "http://docs.oasis-open.org/ns/opencsa/sca/200912");
        }
        return nsContext;
    }

    public void registerPrefix(String prefix, String namespace, NamespaceContext context) {
        NamespaceContextImpl nsContext = (NamespaceContextImpl)context;
        nsContext.register(prefix, namespace);
    }

    private Collection<String> getPrefixes(String expression) {
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.add("");
        Pattern pattern = Pattern.compile("([a-zA-Z.]+):([a-zA-Z.]+)");
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String prefix = this.extractNCName(matcher.group(1), true);
            String local = this.extractNCName(matcher.group(2), false);
            if (prefix == null || local == null) continue;
            prefixes.add(prefix);
        }
        return prefixes;
    }

    private String extractNCName(String str, boolean reverse) {
        int j;
        if (str.length() < 1) {
            return null;
        }
        if (!reverse) {
            int i;
            if (!XMLCharHelper.isNCNameStart(str.charAt(0))) {
                return null;
            }
            int j2 = str.length();
            for (i = 0; i < j2 && XMLCharHelper.isNCName(str.charAt(i)); ++i) {
            }
            return str.substring(0, i);
        }
        for (j = str.length() - 1; j >= 0 && XMLCharHelper.isNCName(str.charAt(j)); --j) {
        }
        if (j != str.length() - 1 && XMLCharHelper.isNCNameStart(str.charAt(j + 1))) {
            return str.substring(j + 1);
        }
        return null;
    }
}

