/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.stax.reader;

import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.common.xml.stax.reader.XMLFragmentStreamReader;

public class XMLDocumentStreamReader
implements XMLStreamReader {
    private static final int STATE_COMPLETE_AT_NEXT = 2;
    private static final int STATE_COMPLETED = 3;
    private static final int STATE_INIT = 0;
    private static final int STATE_SWITCHED = 1;
    private XMLStreamReader realReader;
    private boolean fragment;
    private int level = 1;
    private int state = 0;

    public XMLDocumentStreamReader(XMLStreamReader realReader) {
        if (realReader == null) {
            throw new UnsupportedOperationException("Reader cannot be null");
        }
        this.realReader = realReader;
        if (realReader instanceof XMLFragmentStreamReader) {
            ((XMLFragmentStreamReader)realReader).init();
        }
        if (realReader.getEventType() == 7) {
            this.fragment = false;
            this.state = 1;
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.realReader.close();
    }

    @Override
    public int getAttributeCount() {
        if (this.isDelegating()) {
            return this.realReader.getAttributeCount();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeLocalName(int i) {
        if (this.isDelegating()) {
            return this.realReader.getAttributeLocalName(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public QName getAttributeName(int i) {
        if (this.isDelegating()) {
            return this.realReader.getAttributeName(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeNamespace(int i) {
        if (this.isDelegating()) {
            return this.realReader.getAttributeNamespace(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributePrefix(int i) {
        if (this.isDelegating()) {
            return this.realReader.getAttributePrefix(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeType(int i) {
        if (this.isDelegating()) {
            return this.realReader.getAttributeType(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeValue(int i) {
        if (this.isDelegating()) {
            return this.realReader.getAttributeValue(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeValue(String s, String s1) {
        if (this.isDelegating()) {
            return this.realReader.getAttributeValue(s, s1);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.realReader.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.isDelegating()) {
            return this.realReader.getElementText();
        }
        throw new XMLStreamException();
    }

    @Override
    public String getEncoding() {
        return this.realReader.getEncoding();
    }

    @Override
    public int getEventType() {
        int event = -1;
        switch (this.state) {
            case 1: 
            case 2: {
                event = this.realReader.getEventType();
                break;
            }
            case 0: {
                event = 7;
                break;
            }
            case 3: {
                event = 8;
            }
        }
        return event;
    }

    @Override
    public String getLocalName() {
        if (this.isDelegating()) {
            return this.realReader.getLocalName();
        }
        throw new IllegalStateException();
    }

    @Override
    public Location getLocation() {
        if (this.isDelegating()) {
            return this.realReader.getLocation();
        }
        return null;
    }

    @Override
    public QName getName() {
        if (this.isDelegating()) {
            return this.realReader.getName();
        }
        throw new IllegalStateException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.realReader.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        if (this.isDelegating()) {
            return this.realReader.getNamespaceCount();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespacePrefix(int i) {
        if (this.isDelegating()) {
            return this.realReader.getNamespacePrefix(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespaceURI() {
        if (this.isDelegating()) {
            return this.realReader.getNamespaceURI();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespaceURI(int i) {
        if (this.isDelegating()) {
            return this.realReader.getNamespaceURI(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespaceURI(String s) {
        if (this.isDelegating()) {
            return this.realReader.getNamespaceURI(s);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPIData() {
        if (this.isDelegating()) {
            return this.realReader.getPIData();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPITarget() {
        if (this.isDelegating()) {
            return this.realReader.getPITarget();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPrefix() {
        if (this.isDelegating()) {
            return this.realReader.getPrefix();
        }
        throw new IllegalStateException();
    }

    @Override
    public Object getProperty(String s) throws IllegalArgumentException {
        if (this.isDelegating()) {
            return this.realReader.getProperty(s);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getText() {
        if (this.isDelegating()) {
            return this.realReader.getText();
        }
        throw new IllegalStateException();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.isDelegating()) {
            return this.realReader.getTextCharacters();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        if (this.isDelegating()) {
            return this.realReader.getTextCharacters(i, chars, i1, i2);
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextLength() {
        if (this.isDelegating()) {
            return this.realReader.getTextLength();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextStart() {
        if (this.isDelegating()) {
            return this.realReader.getTextStart();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getVersion() {
        if (this.isDelegating()) {
            return this.realReader.getVersion();
        }
        return null;
    }

    @Override
    public boolean hasName() {
        if (this.isDelegating()) {
            return this.realReader.hasName();
        }
        return false;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.state == 2) {
            return true;
        }
        if (this.state == 3) {
            return false;
        }
        if (this.state == 1) {
            return this.realReader.hasNext();
        }
        return true;
    }

    @Override
    public boolean hasText() {
        if (this.isDelegating()) {
            return this.realReader.hasText();
        }
        return false;
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        if (this.isDelegating()) {
            return this.realReader.isAttributeSpecified(i);
        }
        return false;
    }

    @Override
    public boolean isCharacters() {
        if (this.isDelegating()) {
            return this.realReader.isCharacters();
        }
        return false;
    }

    private boolean isDelegating() {
        return this.state == 1 || this.state == 2;
    }

    @Override
    public boolean isEndElement() {
        if (this.isDelegating()) {
            return this.realReader.isEndElement();
        }
        return false;
    }

    @Override
    public boolean isStandalone() {
        if (this.isDelegating()) {
            return this.realReader.isStandalone();
        }
        return false;
    }

    @Override
    public boolean isStartElement() {
        if (this.isDelegating()) {
            return this.realReader.isStartElement();
        }
        return false;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.isDelegating()) {
            return this.realReader.isWhiteSpace();
        }
        return false;
    }

    @Override
    public int next() throws XMLStreamException {
        int returnEvent;
        switch (this.state) {
            case 1: {
                returnEvent = this.realReader.next();
                if (returnEvent == 8) {
                    this.state = 3;
                } else if (!this.realReader.hasNext()) {
                    this.state = 2;
                }
                if (this.fragment && returnEvent == 2) {
                    --this.level;
                    if (this.level == 0) {
                        this.state = 2;
                    }
                }
                if (!this.fragment || returnEvent != 1) break;
                ++this.level;
                break;
            }
            case 0: {
                this.state = 1;
                returnEvent = this.realReader.getEventType();
                if (returnEvent != 1) break;
                this.level = 0;
                this.fragment = true;
                break;
            }
            case 2: {
                this.state = 3;
                returnEvent = 8;
                break;
            }
            case 3: {
                throw new NoSuchElementException("End of stream has reached.");
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return returnEvent;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (this.isDelegating()) {
            int returnEvent = this.realReader.nextTag();
            if (this.fragment && returnEvent == 2) {
                --this.level;
                if (this.level == 0) {
                    this.state = 2;
                }
            }
            if (this.fragment && returnEvent == 1) {
                ++this.level;
            }
            return returnEvent;
        }
        throw new XMLStreamException();
    }

    @Override
    public void require(int i, String s, String s1) throws XMLStreamException {
        if (this.isDelegating()) {
            this.realReader.require(i, s, s1);
        }
    }

    @Override
    public boolean standaloneSet() {
        if (this.isDelegating()) {
            return this.realReader.standaloneSet();
        }
        return false;
    }
}

