/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.util.Properties;
import org.apache.tuscany.sca.client.impl.DefaultEndpointFinder;
import org.apache.tuscany.sca.client.impl.EndpointFinder;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.NoSuchDomainException;

public class RuntimeUtils {
    public static ExtensionPointRegistry createExtensionPointRegistry() throws NoSuchDomainException {
        DefaultExtensionPointRegistry extensionsRegistry = new DefaultExtensionPointRegistry();
        extensionsRegistry.start();
        FactoryExtensionPoint modelFactories = extensionsRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        RuntimeAssemblyFactory assemblyFactory = new RuntimeAssemblyFactory(extensionsRegistry);
        modelFactories.addFactory(assemblyFactory);
        UtilityExtensionPoint utilities = extensionsRegistry.getExtensionPoint(UtilityExtensionPoint.class);
        Properties domainConfigProps = new Properties();
        domainConfigProps.setProperty("client", "true");
        utilities.getUtility(RuntimeProperties.class).setProperties(domainConfigProps);
        utilities.getUtility(WorkScheduler.class);
        extensionsRegistry.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        return extensionsRegistry;
    }

    public static DomainRegistry getClientEndpointRegistry(ExtensionPointRegistry extensionsRegistry, String domainURI) throws NoSuchDomainException {
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(extensionsRegistry);
        String registryURI = domainURI;
        if (registryURI.indexOf(":") == -1) {
            registryURI = "tuscanyclient:" + registryURI;
        }
        if (registryURI.startsWith("uri:")) {
            registryURI = "tuscanyclient:" + registryURI.substring(4);
        }
        if (registryURI.startsWith("tuscany:")) {
            registryURI = "tuscanyclient:" + registryURI.substring(8);
        }
        try {
            return domainRegistryFactory.getEndpointRegistry(registryURI, domainURI);
        }
        catch (Exception e) {
            throw new NoSuchDomainException(domainURI, e);
        }
    }

    public static EndpointFinder getEndpointFinder(ExtensionPointRegistry registry) {
        EndpointFinder endpointFinder = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(EndpointFinder.class);
        if (endpointFinder == null) {
            endpointFinder = new DefaultEndpointFinder();
        }
        return endpointFinder;
    }
}

