/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.xml;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EndPointReferenceHelper {
    public static Element readEndPointReference(XMLStreamReader reader) {
        try {
            return EndPointReferenceHelper.loadElement(reader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeEndPointReference(Element element, XMLStreamWriter writer, StAXHelper staxHelper) {
        try {
            EndPointReferenceHelper.saveElement(element, writer, staxHelper);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private static Element loadElement(XMLStreamReader reader) throws XMLStreamException, ParserConfigurationException {
        Document document;
        Document root;
        Node current = root = (document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        while (true) {
            switch (reader.getEventType()) {
                case 1: {
                    int i;
                    QName name = reader.getName();
                    Element child = EndPointReferenceHelper.createElement(document, name);
                    current.appendChild(child);
                    current = child;
                    int count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        String ns = reader.getNamespaceURI(i);
                        EndPointReferenceHelper.declareNamespace(child, prefix, ns);
                    }
                    if (!"".equals(name.getNamespaceURI())) {
                        EndPointReferenceHelper.declareNamespace(child, name.getPrefix(), name.getNamespaceURI());
                    }
                    count = reader.getAttributeCount();
                    for (i = 0; i < count; ++i) {
                        String ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String qname = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (prefix != null && prefix.length() != 0) {
                            qname = prefix + ":" + qname;
                        }
                        child.setAttributeNS(ns, qname, value);
                        if (ns == null) continue;
                        EndPointReferenceHelper.declareNamespace(child, prefix, ns);
                    }
                    break;
                }
                case 12: {
                    current.appendChild(document.createCDATASection(reader.getText()));
                    break;
                }
                case 4: {
                    current.appendChild(document.createTextNode(reader.getText()));
                    break;
                }
                case 2: {
                    if ("EndpointReference".equals(reader.getName().getLocalPart())) {
                        return document.getDocumentElement();
                    }
                    current = current.getParentNode();
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
    }

    private static Element createElement(Document document, QName name) {
        String prefix = name.getPrefix();
        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + name.getLocalPart() : name.getLocalPart();
        return document.createElementNS(name.getNamespaceURI(), qname);
    }

    private static void declareNamespace(Element element, String prefix, String ns) {
        NamedNodeMap attrs;
        if (ns == null) {
            ns = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        String qname = null;
        qname = "".equals(prefix) ? "xmlns" : "xmlns:" + prefix;
        boolean declared = false;
        for (Node node = element; node != null && node.getNodeType() == 1 && (attrs = node.getAttributes()) != null; node = node.getParentNode()) {
            Node attr = attrs.getNamedItem(qname);
            if (attr == null) continue;
            declared = ns.equals(attr.getNodeValue());
            break;
        }
        if (!declared) {
            Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            attr.setValue(ns);
            element.setAttributeNodeNS(attr);
        }
    }

    private static void saveElement(Element element, XMLStreamWriter writer, StAXHelper staxHelper) throws XMLStreamException {
        XMLStreamReader reader = staxHelper.createXMLStreamReader(element);
        block6: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    int i;
                    QName name = reader.getName();
                    writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                    int namespaces = reader.getNamespaceCount();
                    for (i = 0; i < namespaces; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        String ns = reader.getNamespaceURI(i);
                        writer.writeNamespace(prefix, ns);
                    }
                    if (!"".equals(name.getNamespaceURI())) {
                        writer.writeNamespace(name.getPrefix(), name.getNamespaceURI());
                    }
                    namespaces = reader.getAttributeCount();
                    for (i = 0; i < namespaces; ++i) {
                        String ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String qname = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        writer.writeAttribute(prefix, ns, qname, value);
                    }
                    continue block6;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                }
            }
        }
    }
}

