/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class DelegatingSCAServiceBindingProvider
implements EndpointAsyncProvider {
    private ServiceBindingProvider provider;
    private RuntimeEndpoint endpoint;
    private RuntimeEndpoint delegateEndpoint;
    private boolean started = false;

    public DelegatingSCAServiceBindingProvider(RuntimeEndpoint endpoint, SCABindingMapper mapper) {
        this.endpoint = endpoint;
        this.delegateEndpoint = mapper.map(endpoint);
        if (this.delegateEndpoint != null) {
            endpoint.setDelegateEndpoint(this.delegateEndpoint);
            this.provider = this.delegateEndpoint.getBindingProvider();
        }
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.provider.getBindingInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return this.provider.supportsOneWayInvocation();
    }

    @Override
    public void configure() {
        if (this.provider instanceof EndpointProvider) {
            ((EndpointProvider)this.provider).configure();
        }
    }

    @Override
    public boolean supportsNativeAsync() {
        if (this.provider instanceof EndpointAsyncProvider) {
            return ((EndpointAsyncProvider)this.provider).supportsNativeAsync();
        }
        return false;
    }

    @Override
    public InvokerAsyncResponse createAsyncResponseInvoker() {
        if (this.provider instanceof EndpointAsyncProvider) {
            return ((EndpointAsyncProvider)this.provider).createAsyncResponseInvoker();
        }
        return null;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.provider.start();
        ((SCABinding)this.endpoint.getBinding()).setDelegateBindingType(this.delegateEndpoint.getBinding().getType().toString());
        ((SCABinding)this.endpoint.getBinding()).setDelegateBindingURI(this.delegateEndpoint.getBinding().getURI());
        this.endpoint.setDeployedURI(this.delegateEndpoint.getDeployedURI());
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.provider.stop();
        }
        finally {
            this.started = false;
        }
    }

    public ServiceBindingProvider getProviderDelegate() {
        return this.provider;
    }

    public RuntimeEndpoint getDelegateEndpoint() {
        return this.delegateEndpoint;
    }
}

