/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.local;

import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.binding.local.LocalSCABindingInvoker;
import org.apache.tuscany.sca.binding.sca.transform.BindingSCATransformer;
import org.apache.tuscany.sca.binding.sca.transform.SameDBCopyTransformer;
import org.apache.tuscany.sca.binding.sca.transform.WSDLMediateTransformer;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.util.OperationDataBindingHelper;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class DefaultLocalSCAReferenceBindingProvider
implements EndpointReferenceAsyncProvider {
    private RuntimeEndpointReference endpointReference;
    protected InterfaceContractMapper interfaceContractMapper;
    protected ExtensionPointRegistry extensionPoints;
    protected Mediator mediator;
    protected InterfaceContract componentTypeRefInterfaceContract;
    protected InterfaceContract wsdlBindingInterfaceContract;

    public DefaultLocalSCAReferenceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpointReference endpointReference, SCABindingMapper mapper) {
        this.extensionPoints = extensionPoints;
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.mediator = utilities.getUtility(Mediator.class);
        this.endpointReference = endpointReference;
    }

    protected String getDataBinding() {
        return DOMDataBinding.NAME;
    }

    protected InterfaceContract getWSDLBindingInterfaceContract() {
        if (this.wsdlBindingInterfaceContract != null) {
            return this.wsdlBindingInterfaceContract;
        }
        WSDLInterfaceContract wsdlInterfaceContract = (WSDLInterfaceContract)this.endpointReference.getGeneratedWSDLContract(this.componentTypeRefInterfaceContract);
        Endpoint target = this.endpointReference.getTargetEndpoint();
        InterfaceContract targetInterfaceContract = target.getComponentServiceInterfaceContract();
        try {
            this.interfaceContractMapper.checkCompatibility(wsdlInterfaceContract, targetInterfaceContract, Compatibility.SUBSET, true, false);
        }
        catch (IncompatibleInterfaceContractException exc) {
            throw new ServiceRuntimeException(exc);
        }
        String dataBinding = this.getDataBinding();
        try {
            wsdlInterfaceContract = (WSDLInterfaceContract)wsdlInterfaceContract.clone();
        }
        catch (CloneNotSupportedException exc) {
            throw new ServiceRuntimeException(exc);
        }
        if (wsdlInterfaceContract.getInterface() != null) {
            wsdlInterfaceContract.getInterface().resetDataBinding(dataBinding);
        }
        if (wsdlInterfaceContract.getCallbackInterface() != null) {
            wsdlInterfaceContract.getCallbackInterface().resetDataBinding(dataBinding);
        }
        this.wsdlBindingInterfaceContract = wsdlInterfaceContract;
        return wsdlInterfaceContract;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        this.componentTypeRefInterfaceContract = this.endpointReference.getComponentTypeReferenceInterfaceContract();
        return this.componentTypeRefInterfaceContract;
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        RuntimeComponentService service;
        LocalSCABindingInvoker result = null;
        BindingSCATransformer bindingTransformer = null;
        Endpoint target = this.endpointReference.getTargetEndpoint();
        if (target != null && (service = (RuntimeComponentService)target.getService()) != null) {
            InvocationChain chain = ((RuntimeEndpoint)target).getInvocationChain(operation);
            boolean passByValue = false;
            Operation targetOp = chain.getTargetOperation();
            if (!operation.getInterface().isRemotable()) {
                if (this.interfaceContractMapper.isCompatibleByReference(operation, targetOp, Compatibility.SUBSET)) {
                    passByValue = false;
                }
            } else {
                boolean allowsPBR;
                Reference ref = this.endpointReference.getReference().getReference();
                boolean bl = allowsPBR = (this.endpointReference.getReference().isAllowsPassByReference() || ref != null && ref.isAllowsPassByReference()) && chain.allowsPassByReference();
                if (allowsPBR && this.interfaceContractMapper.isCompatibleByReference(operation, targetOp, Compatibility.SUBSET)) {
                    passByValue = false;
                } else if (this.interfaceContractMapper.isCompatibleWithoutUnwrapByValue(operation, targetOp, Compatibility.SUBSET)) {
                    passByValue = true;
                } else {
                    throw new IllegalStateException();
                }
                bindingTransformer = this.getBindingTransformer(operation, targetOp);
            }
            LocalSCABindingInvoker localSCABindingInvoker = result = chain == null ? null : new LocalSCABindingInvoker(chain, operation, passByValue, this.endpointReference, this.extensionPoints, bindingTransformer);
        }
        if (result == null) {
            throw new ServiceUnavailableException("Unable to create SCA binding invoker for local target " + this.endpointReference.getComponent().getName() + " reference " + this.endpointReference.getReference().getName() + " (bindingURI=" + this.endpointReference.getBinding().getURI() + " operation=" + operation.getName() + ")");
        }
        return result;
    }

    protected BindingSCATransformer getBindingTransformer(Operation sourceOperation, Operation targetOperation) {
        boolean differentDataBindings = OperationDataBindingHelper.isTransformationRequired(sourceOperation, targetOperation);
        if (differentDataBindings) {
            InterfaceContract bindingInterfaceContract = this.getWSDLBindingInterfaceContract();
            if (!bindingInterfaceContract.getInterface().isRemotable()) {
                throw new IllegalStateException("This method should only have been called for a remotable interface.");
            }
            Operation wsdlBindingOperation = this.interfaceContractMapper.map(bindingInterfaceContract.getInterface(), sourceOperation);
            return new WSDLMediateTransformer(this.mediator, sourceOperation, wsdlBindingOperation, targetOperation);
        }
        return new SameDBCopyTransformer(this.mediator, sourceOperation, targetOperation);
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    @Override
    public boolean supportsNativeAsync() {
        return true;
    }

    @Override
    public void configure() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public void setEndpointReference(RuntimeEndpointReference endpointReference) {
        this.endpointReference = endpointReference;
    }
}

