/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.ExtensibleImpl;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;

public class ComponentTypeImpl
extends ExtensibleImpl
implements ComponentType,
Cloneable {
    private String uri;
    private List<Property> properties = new ArrayList<Property>();
    private List<Reference> references = new ArrayList<Reference>();
    private List<Service> services = new ArrayList<Service>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();

    protected ComponentTypeImpl() {
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentTypeImpl clone = (ComponentTypeImpl)super.clone();
        clone.services = new ArrayList<Service>();
        for (Service service : this.getServices()) {
            clone.services.add((Service)service.clone());
        }
        clone.references = new ArrayList<Reference>();
        for (Reference reference : this.getReferences()) {
            clone.references.add((Reference)reference.clone());
        }
        clone.properties = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            clone.properties.add((Property)property.clone());
        }
        clone.requiredIntents = new ArrayList<Intent>(this.requiredIntents);
        clone.policySets = new ArrayList<PolicySet>(this.policySets);
        return clone;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Property getProperty(String name) {
        Property property = null;
        for (Property tmp : this.getProperties()) {
            if (!tmp.getName().equals(name)) continue;
            property = tmp;
            break;
        }
        return property;
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public Reference getReference(String name) {
        Reference reference = null;
        for (Reference tmp : this.getReferences()) {
            if (!tmp.getName().equals(name)) continue;
            reference = tmp;
            break;
        }
        return reference;
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public Service getService(String name) {
        Service service = null;
        for (Service tmp : this.getServices()) {
            if (!tmp.getName().equals(name)) continue;
            service = tmp;
            break;
        }
        return service;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    @Override
    public ExtensionType getExtensionType() {
        return null;
    }

    @Override
    public void setExtensionType(ExtensionType type) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentTypeImpl other = (ComponentTypeImpl)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

