/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.Audit;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.policy.ExtensionType;

public class InterfaceContractMapperImpl
implements InterfaceContractMapper {
    protected ExtensionPointRegistry registry;
    protected BuilderExtensionPoint builders;
    protected ContractBuilder contractBuilder;

    public InterfaceContractMapperImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.builders = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
    }

    public boolean isCompatible(DataType source, DataType target, boolean passByValue) {
        return this.isCompatible(source, target, passByValue, null);
    }

    public boolean isCompatible(DataType source, DataType target, boolean passByValue, Audit audit) {
        if (source == target) {
            return true;
        }
        if (!passByValue) {
            if (source == null || target == null) {
                if (audit != null) {
                    audit.append("One of either the source or target data types is null for");
                }
                return false;
            }
            return target.getPhysical().isAssignableFrom(source.getPhysical());
        }
        XMLType sourceLogicalType = null;
        while (source.getLogical() instanceof DataType) {
            source = (DataType)source.getLogical();
        }
        sourceLogicalType = (XMLType)source.getLogical();
        XMLType targetLogicalType = null;
        while (target.getLogical() instanceof DataType) {
            target = (DataType)target.getLogical();
        }
        targetLogicalType = (XMLType)target.getLogical();
        if (sourceLogicalType.getTypeName() == null || targetLogicalType.getTypeName() == null) {
            return true;
        }
        boolean match = sourceLogicalType.getTypeName().equals(targetLogicalType.getTypeName());
        if (!match) {
            QName anyType = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
            if (sourceLogicalType.getTypeName().equals(anyType) || targetLogicalType.getTypeName().equals(anyType)) {
                match = true;
            } else if (audit != null) {
                audit.append("Operation argument types source = " + sourceLogicalType.getTypeName() + " target = " + targetLogicalType.getTypeName() + " don't match for");
            }
        }
        return match;
    }

    @Override
    public boolean isMutuallyCompatible(InterfaceContract source, InterfaceContract target) {
        ExtensionType ext = source.getInterface().getExtensionType();
        Object sourceContract = null;
        if (this.isMutuallyCompatible(source.getInterface(), target.getInterface())) {
            if (source.getCallbackInterface() == null && target.getCallbackInterface() == null) {
                return true;
            }
            if (this.isMutuallyCompatible(source.getCallbackInterface(), target.getCallbackInterface())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMutuallyCompatible(Interface source, Interface target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.isDynamic() || target.isDynamic()) {
            return true;
        }
        if (source.isRemotable() != target.isRemotable()) {
            return false;
        }
        if (source.getOperations().size() != target.getOperations().size()) {
            return false;
        }
        for (Operation operation : source.getOperations()) {
            Operation targetOperation = this.getOperation(target.getOperations(), operation.getName());
            if (targetOperation == null) {
                return false;
            }
            if (this.isCompatible(operation, targetOperation, Compatibility.SUBSET)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatible(Operation source, Operation target, Compatibility compatibilityType) {
        return this.isCompatible(source, target, compatibilityType, true);
    }

    public boolean isCompatible(Operation source, Operation target, Compatibility compatibilityType, boolean byValue) {
        return this.isCompatible(source, target, compatibilityType, true, null);
    }

    public boolean isCompatible(Operation source, Operation target, Compatibility compatibilityType, boolean byValue, Audit audit) {
        if (source == target) {
            return true;
        }
        if (source.isDynamic() || target.isDynamic()) {
            return true;
        }
        if (!source.getName().equals(target.getName())) {
            if (audit != null) {
                audit.append("operation names are not the same source = " + source.getName() + " target = " + target.getName());
                audit.appendSeperator();
            }
            return false;
        }
        if (source.getInterface().isRemotable() != target.getInterface().isRemotable()) {
            if (audit != null) {
                audit.append("Interfaces have different remote settings source = " + source.getName() + " target = " + target.getName());
                audit.appendSeperator();
            }
            return false;
        }
        if (source.isNonBlocking() != target.isNonBlocking()) {
            if (audit != null) {
                audit.append("operations one-way not the same, source = " + source.isNonBlocking() + " target = " + target.isNonBlocking());
                audit.appendSeperator();
            }
            return false;
        }
        boolean passByValue = source.getInterface().isRemotable() && byValue;
        List<DataType> sourceOutputType = source.getOutputType().getLogical();
        List<DataType> targetOutputType = target.getOutputType().getLogical();
        List<DataType> sourceInputType = source.getInputType().getLogical();
        List<DataType> targetInputType = target.getInputType().getLogical();
        if (source.isInputWrapperStyle() && source.getInputWrapper() != null) {
            sourceInputType = source.getInputWrapper().getUnwrappedType().getLogical();
        }
        if (source.isOutputWrapperStyle() && source.getOutputWrapper() != null) {
            sourceOutputType = source.getOutputWrapper().getUnwrappedType().getLogical();
        }
        if (target.isInputWrapperStyle() && target.getInputWrapper() != null) {
            targetInputType = target.getInputWrapper().getUnwrappedType().getLogical();
        }
        if (target.isOutputWrapperStyle() && target.getOutputWrapper() != null) {
            targetOutputType = target.getOutputWrapper().getUnwrappedType().getLogical();
        }
        if (sourceOutputType.size() != targetOutputType.size()) {
            if (audit != null) {
                audit.append("different number of output types");
                audit.appendSeperator();
            }
            return false;
        }
        for (int i = 0; i < sourceOutputType.size(); ++i) {
            if (this.isCompatible(targetOutputType.get(i), sourceOutputType.get(i), passByValue, audit)) continue;
            if (audit != null) {
                audit.append(" output types");
                audit.appendSeperator();
            }
            return false;
        }
        if (sourceInputType.size() != targetInputType.size()) {
            if (audit != null) {
                audit.append("different number of input types");
                audit.appendSeperator();
            }
            return false;
        }
        int size = sourceInputType.size();
        for (int i = 0; i < size; ++i) {
            if (this.isCompatible(sourceInputType.get(i), targetInputType.get(i), passByValue, audit)) continue;
            if (audit != null) {
                audit.append(" input types");
                audit.appendSeperator();
            }
            return false;
        }
        for (DataType targetFaultType : target.getFaultTypes()) {
            boolean found = true;
            for (DataType sourceFaultType : source.getFaultTypes()) {
                found = false;
                if (!this.isCompatible(targetFaultType, sourceFaultType, passByValue, audit)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (audit != null) {
                audit.append("Fault types incompatible");
                audit.appendSeperator();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatibleByReference(Operation source, Operation target, Compatibility compatibilityType) {
        return this.isCompatible(source, target, compatibilityType, false);
    }

    @Override
    public boolean isCompatibleByValue(Operation source, Operation target, Compatibility compatibilityType) {
        return this.isCompatible(source, target, compatibilityType, true);
    }

    @Override
    public boolean isCompatibleWithoutUnwrapByValue(Operation source, Operation target, Compatibility compatibilityType) {
        if (!source.isInputWrapperStyle() == target.isInputWrapperStyle()) {
            return false;
        }
        if (!source.isOutputWrapperStyle() == target.isOutputWrapperStyle()) {
            return false;
        }
        return this.isCompatible(source, target, compatibilityType, true);
    }

    private Operation getOperation(List<Operation> operations, String name) {
        for (Operation op : operations) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    @Override
    public boolean checkCompatibility(InterfaceContract source, InterfaceContract target, Compatibility compatibility, boolean ignoreCallback, boolean silent, Audit audit) throws IncompatibleInterfaceContractException {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.getInterface() == target.getInterface()) {
            return ignoreCallback || this.isCallbackCompatible(source, target, silent, audit);
        }
        if (source.getInterface() == null || target.getInterface() == null) {
            return false;
        }
        if (source.getInterface().isDynamic() || target.getInterface().isDynamic()) {
            return ignoreCallback || this.isCallbackCompatible(source, target, silent, audit);
        }
        if (source.getInterface().isRemotable() != target.getInterface().isRemotable()) {
            if (!silent) {
                audit.append("Remotable settings do not match: " + source + "," + target);
                audit.appendSeperator();
                throw new IncompatibleInterfaceContractException("Remotable settings do not match", source, target);
            }
            return false;
        }
        for (Operation operation : source.getInterface().getOperations()) {
            Operation targetOperation = this.map(target.getInterface(), operation);
            if (targetOperation == null) {
                if (!silent) {
                    audit.append("Operation " + operation.getName() + " not found on target");
                    audit.appendSeperator();
                    throw new IncompatibleInterfaceContractException("Operation " + operation.getName() + " not found on target", source, target);
                }
                return false;
            }
            if (!silent) {
                if (audit == null) {
                    audit = new Audit();
                }
                if (this.isCompatible(operation, targetOperation, Compatibility.SUBSET, true, audit)) continue;
                audit.append("Operations called " + operation.getName() + " are not compatible");
                audit.appendSeperator();
                throw new IncompatibleInterfaceContractException("Operations called " + operation.getName() + " are not compatible " + audit, source, target);
            }
            if (this.isCompatible(operation, targetOperation, Compatibility.SUBSET)) continue;
            return false;
        }
        return ignoreCallback || this.isCallbackCompatible(source, target, silent, audit);
    }

    @Override
    public boolean checkCompatibility(InterfaceContract source, InterfaceContract target, Compatibility compatibility, boolean ignoreCallback, boolean silent) throws IncompatibleInterfaceContractException {
        Audit audit = new Audit();
        return this.checkCompatibility(source, target, compatibility, ignoreCallback, silent, audit);
    }

    protected boolean isCallbackCompatible(InterfaceContract source, InterfaceContract target, boolean silent, Audit audit) throws IncompatibleInterfaceContractException {
        if (source.getCallbackInterface() == null && target.getCallbackInterface() == null) {
            return true;
        }
        if (source.getCallbackInterface() == null || target.getCallbackInterface() == null) {
            if (!silent) {
                audit.append("Callback interface doesn't match as one of the callback interfaces is null");
                audit.appendSeperator();
                throw new IncompatibleInterfaceContractException("Callback interface doesn't match as one of the callback interfaces is null", source, target);
            }
            return false;
        }
        for (Operation operation : source.getCallbackInterface().getOperations()) {
            Operation targetOperation = this.getOperation(target.getCallbackInterface().getOperations(), operation.getName());
            if (targetOperation == null) {
                if (!silent) {
                    audit.append("Callback operation not found on target " + operation.getName());
                    audit.appendSeperator();
                    throw new IncompatibleInterfaceContractException("Callback operation not found on target", source, target, null, targetOperation);
                }
                return false;
            }
            if (source.getCallbackInterface().isRemotable() || operation.equals(targetOperation)) continue;
            if (!silent) {
                audit.append("Target callback operation is not compatible " + operation.getName());
                audit.appendSeperator();
                throw new IncompatibleInterfaceContractException("Target callback operation is not compatible", source, target, operation, targetOperation);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatibleSubset(Interface source, Interface target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.isDynamic() || target.isDynamic()) {
            return true;
        }
        if (source.isRemotable() != target.isRemotable()) {
            return false;
        }
        for (Operation operation : source.getOperations()) {
            Operation targetOperation = this.getOperation(target.getOperations(), operation.getName());
            if (targetOperation == null) {
                return false;
            }
            if (this.isCompatible(operation, targetOperation, Compatibility.SUBSET)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatibleSubset(InterfaceContract source, InterfaceContract target, Audit audit) {
        try {
            return this.checkCompatibility(source, target, Compatibility.SUBSET, false, false, audit);
        }
        catch (IncompatibleInterfaceContractException e) {
            return false;
        }
    }

    @Override
    public boolean isCompatibleSubset(InterfaceContract source, InterfaceContract target) {
        try {
            return this.checkCompatibility(source, target, Compatibility.SUBSET, false, false);
        }
        catch (IncompatibleInterfaceContractException e) {
            return false;
        }
    }

    @Override
    public Operation map(Interface target, Operation source) {
        if (target == null || target.isDynamic()) {
            return source;
        }
        if (target.isRemotable()) {
            for (Operation op : target.getOperations()) {
                if (!op.getName().equals(source.getName())) continue;
                return op;
            }
            return null;
        }
        for (Operation op : target.getOperations()) {
            if (!this.isCompatible(source, op, Compatibility.SUBSET)) continue;
            return op;
        }
        return null;
    }
}

