/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.DefaultMonitorFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;

public class BuilderContext {
    protected Definitions definitions;
    protected Map<QName, List<String>> bindingBaseURIs = Collections.emptyMap();
    protected Monitor monitor;

    public BuilderContext(Definitions definitions, Map<QName, List<String>> bindingBaseURIs, Monitor monitor) {
        this.definitions = definitions;
        if (bindingBaseURIs != null) {
            this.bindingBaseURIs = bindingBaseURIs;
        }
        this.monitor = monitor;
    }

    public BuilderContext(Monitor monitor) {
        this.monitor = monitor;
    }

    public BuilderContext(ExtensionPointRegistry registry) {
        MonitorFactory monitorFactory = (MonitorFactory)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
    }

    public BuilderContext() {
        this.monitor = new DefaultMonitorFactory().createMonitor();
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public Monitor setMonitor(Monitor monitor) {
        Monitor old = this.monitor;
        this.monitor = monitor;
        return old;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public Map<QName, List<String>> getBindingBaseURIs() {
        return this.bindingBaseURIs;
    }

    public void setDefinitions(Definitions definitions) {
        this.definitions = definitions;
    }
}

