/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReferenceConfigurationUtil {
    ReferenceConfigurationUtil() {
    }

    private static void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(ReferenceConfigurationUtil.class.getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    static boolean isValidMultiplicityOverride(Multiplicity definedMul, Multiplicity overridenMul) {
        if (definedMul != overridenMul) {
            switch (definedMul) {
                case ZERO_N: {
                    return overridenMul == Multiplicity.ZERO_ONE;
                }
                case ONE_N: {
                    return overridenMul == Multiplicity.ONE_ONE;
                }
            }
            return false;
        }
        return true;
    }

    static boolean validateMultiplicityAndTargets(Multiplicity multiplicity, List<?> targets, List<Binding> bindings) {
        int count = targets.size();
        if (multiplicity == null) {
            return true;
        }
        switch (multiplicity) {
            case ZERO_N: {
                break;
            }
            case ZERO_ONE: {
                if (count <= 1) break;
                return false;
            }
            case ONE_ONE: {
                if (count == 1) break;
                if (count == 0) {
                    for (Binding binding : bindings) {
                        if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
                        return true;
                    }
                }
                return false;
            }
            case ONE_N: {
                if (count >= 1) break;
                if (count == 0) {
                    for (Binding binding : bindings) {
                        if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    static List<ComponentReference> getPromotedComponentReferences(CompositeReference compositeReference) {
        ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
        ReferenceConfigurationUtil.collectPromotedComponentReferences(compositeReference, componentReferences);
        return componentReferences;
    }

    private static void collectPromotedComponentReferences(CompositeReference compositeReference, List<ComponentReference> componentReferences) {
        for (ComponentReference componentReference : compositeReference.getPromotedReferences()) {
            Reference reference = componentReference.getReference();
            if (reference instanceof CompositeReference) {
                ReferenceConfigurationUtil.collectPromotedComponentReferences((CompositeReference)reference, componentReferences);
                continue;
            }
            if (reference == null) continue;
            componentReferences.add(componentReference);
        }
    }

    static void reconcileReferenceBindings(Reference reference, ComponentReference promotedReference, AssemblyFactory assemblyFactory, Monitor monitor) {
        if (promotedReference.getMultiplicity() == Multiplicity.ONE_ONE || promotedReference.getMultiplicity() == Multiplicity.ZERO_ONE) {
            if (reference.getEndpointReferences().size() > 0) {
                promotedReference.getEndpointReferences().clear();
                promotedReference.getEndpointReferences().addAll(reference.getEndpointReferences());
            }
            if (promotedReference.getEndpointReferences().size() > 1) {
                ReferenceConfigurationUtil.warning(monitor, "ComponentReferenceMoreWire", promotedReference, promotedReference.getName());
            }
        } else if (reference.getEndpointReferences().size() > 0) {
            promotedReference.getEndpointReferences().addAll(reference.getEndpointReferences());
        }
        HashSet<Binding> callbackBindings = new HashSet<Binding>();
        if (promotedReference.getCallback() != null) {
            callbackBindings.addAll(promotedReference.getCallback().getBindings());
        }
        if (reference.getCallback() != null) {
            callbackBindings.addAll(reference.getCallback().getBindings());
        }
        promotedReference.setCallback(assemblyFactory.createCallback());
        for (Binding binding : callbackBindings) {
            if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
            promotedReference.getCallback().getBindings().add(binding);
        }
    }
}

