/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.impl.PolicyConfigurationException;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentMap;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.util.PolicyComputationUtils;
import org.apache.tuscany.sca.policy.util.PolicyValidationException;
import org.apache.tuscany.sca.policy.util.PolicyValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PolicyConfigurationUtil {
    PolicyConfigurationUtil() {
    }

    private static List<Intent> computeInheritableIntents(ExtensionType attachPointType, List<Intent> inheritableIntents) throws PolicyValidationException {
        ArrayList<Intent> validInheritableIntents = new ArrayList<Intent>();
        PolicyComputationUtils.expandProfileIntents(inheritableIntents);
        block0: for (Intent intent : inheritableIntents) {
            if (!intent.isUnresolved()) {
                for (ExtensionType constrained : intent.getConstrainedTypes()) {
                    if (!PolicyValidationUtils.isConstrained((ExtensionType)constrained, (ExtensionType)attachPointType)) continue;
                    validInheritableIntents.add(intent);
                    continue block0;
                }
                continue;
            }
            throw new PolicyValidationException("Policy Intent '" + intent.getName() + "' is not defined in this domain");
        }
        return validInheritableIntents;
    }

    private static void normalizeIntents(PolicySubject intentAttachPoint) {
        PolicyComputationUtils.expandProfileIntents((List)intentAttachPoint.getRequiredIntents());
        PolicyConfigurationUtil.filterDuplicatesAndQualifiableIntents(intentAttachPoint);
    }

    private static void trimInherentlyProvidedIntents(ExtensionType attachPointType, List<Intent> intents) {
        ArrayList<Intent> requiredIntents = new ArrayList<Intent>(intents);
        for (Intent intent : requiredIntents) {
            if (!PolicyConfigurationUtil.isProvidedInherently(attachPointType, intent)) continue;
            intents.remove(intent);
        }
    }

    private static List<PolicySet> computeInheritablePolicySets(List<PolicySet> inheritablePolicySets) throws PolicyValidationException {
        return inheritablePolicySets;
    }

    private static void normalizePolicySets(PolicySubject subject) {
        HashSet policySetTable = new HashSet(subject.getPolicySets());
        subject.getPolicySets().clear();
        subject.getPolicySets().addAll(policySetTable);
        for (PolicySet policySet : subject.getPolicySets()) {
            PolicyComputationUtils.expandProfileIntents((List)policySet.getProvidedIntents());
        }
    }

    private static void trimProvidedIntents(List<Intent> requiredIntents, List<PolicySet> policySets) {
        for (PolicySet policySet : policySets) {
            PolicyConfigurationUtil.trimProvidedIntents(requiredIntents, policySet);
        }
    }

    private static void determineApplicableDomainPolicySets(List<PolicySet> applicablePolicySets, PolicySubject policySetAttachPoint, ExtensionType intentAttachPointType) {
        if (policySetAttachPoint.getRequiredIntents().size() > 0) {
            ArrayList combinedTargetIntents = new ArrayList();
            combinedTargetIntents.addAll(policySetAttachPoint.getRequiredIntents());
            for (PolicySet targetPolicySet : policySetAttachPoint.getPolicySets()) {
                combinedTargetIntents.addAll(PolicyComputationUtils.findAndExpandProfileIntents((List)targetPolicySet.getProvidedIntents()));
            }
            for (PolicySet policySet : applicablePolicySets) {
                boolean conflict = false;
                List providedIntents = PolicyComputationUtils.findAndExpandProfileIntents((List)policySet.getProvidedIntents());
                block2: for (Intent intent : providedIntents) {
                    for (Intent excluded : intent.getExcludedIntents()) {
                        if (!combinedTargetIntents.contains(excluded)) continue;
                        conflict = true;
                        break block2;
                    }
                }
                if (conflict) continue;
                int prevSize = policySetAttachPoint.getRequiredIntents().size();
                PolicyConfigurationUtil.trimProvidedIntents((List<Intent>)policySetAttachPoint.getRequiredIntents(), policySet);
                if (prevSize == policySetAttachPoint.getRequiredIntents().size()) continue;
                policySetAttachPoint.getPolicySets().add(policySet);
            }
        }
    }

    private static boolean isProvidedInherently(ExtensionType attachPointType, Intent intent) {
        return attachPointType != null && (attachPointType.getAlwaysProvidedIntents() != null && attachPointType.getAlwaysProvidedIntents().contains(intent) || attachPointType.getMayProvidedIntents() != null && attachPointType.getMayProvidedIntents().contains(intent));
    }

    private static void trimProvidedIntents(List<Intent> requiredIntents, PolicySet policySet) {
        for (Intent providedIntent : policySet.getProvidedIntents()) {
            if (!requiredIntents.contains(providedIntent)) continue;
            requiredIntents.remove(providedIntent);
        }
        for (IntentMap intentMap : policySet.getIntentMaps()) {
            if (!requiredIntents.contains(intentMap.getProvidedIntent())) continue;
            requiredIntents.remove(intentMap.getProvidedIntent());
        }
    }

    private static void filterDuplicatesAndQualifiableIntents(PolicySubject intentAttachPoint) {
        HashMap<QName, Intent> intentsTable = new HashMap<QName, Intent>();
        for (Intent intent : intentAttachPoint.getRequiredIntents()) {
            intentsTable.put(intent.getName(), intent);
        }
        HashMap intentsTableCopy = new HashMap(intentsTable);
        for (Intent intent : intentsTableCopy.values()) {
            if (intent.getQualifiableIntent() == null || intentsTable.get(intent.getQualifiableIntent().getName()) == null) continue;
            intentsTable.remove(intent.getQualifiableIntent().getName());
        }
        intentAttachPoint.getRequiredIntents().clear();
        intentAttachPoint.getRequiredIntents().addAll(intentsTable.values());
    }

    static void computeBindingIntentsAndPolicySets(Contract contract) throws PolicyValidationException {
        PolicySubject policiedBinding;
        for (Binding binding : contract.getBindings()) {
            if (!(binding instanceof PolicySubject)) continue;
            policiedBinding = (PolicySubject)binding;
            PolicyConfigurationUtil.computeIntents((PolicySubject)binding, contract.getRequiredIntents());
            PolicyConfigurationUtil.computePolicySets(policiedBinding, contract.getPolicySets());
            PolicyComputationUtils.checkForMutuallyExclusiveIntents((List)policiedBinding.getRequiredIntents(), (List)policiedBinding.getPolicySets(), (ExtensionType)policiedBinding.getType(), (String)contract.getName());
        }
        if (contract.getCallback() != null) {
            for (Binding binding : contract.getCallback().getBindings()) {
                if (!(binding instanceof PolicySubject)) continue;
                policiedBinding = (PolicySubject)binding;
                PolicyConfigurationUtil.computeIntents((PolicySubject)binding, contract.getCallback().getRequiredIntents());
                PolicyConfigurationUtil.computePolicySets(policiedBinding, contract.getCallback().getPolicySets());
                PolicyComputationUtils.checkForMutuallyExclusiveIntents((List)policiedBinding.getRequiredIntents(), (List)policiedBinding.getPolicySets(), (ExtensionType)policiedBinding.getType(), (String)(String.valueOf(contract.getName()) + " callback"));
            }
        }
    }

    private static void computeIntents(PolicySubject policiedBinding, List<Intent> inheritedIntents) throws PolicyValidationException {
        List<Intent> prunedIntents = PolicyConfigurationUtil.computeInheritableIntents(policiedBinding.getType(), inheritedIntents);
        policiedBinding.getRequiredIntents().addAll(prunedIntents);
        PolicyConfigurationUtil.normalizeIntents(policiedBinding);
    }

    private static void computePolicySets(PolicySubject policiedBinding, List<PolicySet> inheritedPolicySets) throws PolicyValidationException {
        List<PolicySet> prunedPolicySets = PolicyConfigurationUtil.computeInheritablePolicySets(inheritedPolicySets);
        policiedBinding.getPolicySets().addAll(prunedPolicySets);
        PolicyConfigurationUtil.normalizePolicySets(policiedBinding);
    }

    static void determineApplicableBindingPolicySets(Contract source, Contract target) throws PolicyConfigurationException {
        ArrayList intentsCopy = null;
        for (Binding aBinding : source.getBindings()) {
            if (!(aBinding instanceof PolicySubject)) continue;
            PolicySubject policiedBinding = (PolicySubject)aBinding;
            ExtensionType bindingType = policiedBinding.getType();
            intentsCopy = new ArrayList(policiedBinding.getRequiredIntents());
            if (target != null) {
                block1: for (Intent intent : target.getRequiredIntents()) {
                    if (policiedBinding.getRequiredIntents().contains(intent)) continue;
                    for (ExtensionType constrained : intent.getConstrainedTypes()) {
                        if (bindingType == null || !bindingType.getType().getNamespaceURI().equals(constrained.getType().getNamespaceURI()) || !bindingType.getType().getLocalPart().startsWith(constrained.getType().getLocalPart())) continue;
                        policiedBinding.getRequiredIntents().add(intent);
                        continue block1;
                    }
                }
            }
            PolicyConfigurationUtil.trimInherentlyProvidedIntents(policiedBinding.getType(), policiedBinding.getRequiredIntents());
            PolicyConfigurationUtil.trimProvidedIntents((List<Intent>)policiedBinding.getRequiredIntents(), policiedBinding.getPolicySets());
            PolicyConfigurationUtil.determineApplicableDomainPolicySets(source, policiedBinding);
            policiedBinding.getRequiredIntents().clear();
            policiedBinding.getRequiredIntents().addAll(intentsCopy);
        }
    }

    private static void determineApplicableDomainPolicySets(Contract contract, PolicySubject policiedBinding) throws PolicyConfigurationException {
    }

    private static void aggregateAndPruneApplicablePolicySets(List<PolicySet> source, List<PolicySet> target) {
        target.addAll(source);
        Hashtable<QName, PolicySet> policySetTable = new Hashtable<QName, PolicySet>();
        for (PolicySet policySet : target) {
            policySetTable.put(policySet.getName(), policySet);
        }
        target.clear();
        target.addAll(policySetTable.values());
    }

    static <C extends Contract> void inheritDefaultPolicies(Base parent, List<C> contracts) {
        for (Contract contract : contracts) {
            if (parent instanceof PolicySubject) {
                PolicyComputationUtils.addDefaultPolicies((List)((PolicySubject)parent).getRequiredIntents(), (List)((PolicySubject)parent).getPolicySets(), (List)contract.getRequiredIntents(), (List)contract.getPolicySets());
            }
            if (contract.getCallback() == null) continue;
            PolicyComputationUtils.addDefaultPolicies((List)contract.getRequiredIntents(), (List)contract.getPolicySets(), (List)contract.getCallback().getRequiredIntents(), (List)contract.getCallback().getPolicySets());
        }
    }

    static void computeImplementationIntentsAndPolicySets(Implementation implementation, Component parent) throws PolicyValidationException, PolicyConfigurationException {
        if (implementation instanceof PolicySubject) {
            Implementation policiedImplementation = implementation;
            List<Intent> prunedIntents = PolicyConfigurationUtil.computeInheritableIntents(policiedImplementation.getType(), parent.getRequiredIntents());
            parent.getRequiredIntents().clear();
            parent.getRequiredIntents().addAll(prunedIntents);
            PolicyConfigurationUtil.normalizeIntents(parent);
            List<PolicySet> prunedPolicySets = PolicyConfigurationUtil.computeInheritablePolicySets(parent.getPolicySets());
            parent.getPolicySets().clear();
            parent.getPolicySets().addAll(prunedPolicySets);
            PolicyConfigurationUtil.normalizePolicySets(parent);
            PolicyComputationUtils.checkForMutuallyExclusiveIntents((List)parent.getRequiredIntents(), (List)parent.getPolicySets(), (ExtensionType)policiedImplementation.getType(), (String)parent.getName());
            PolicyConfigurationUtil.determineApplicableImplementationPolicySets(parent);
        }
    }

    private static void determineApplicableImplementationPolicySets(Component component) throws PolicyConfigurationException {
        ArrayList intentsCopy = null;
        if (component.getImplementation() instanceof PolicySubject) {
            Implementation policiedImplementation = component.getImplementation();
            intentsCopy = new ArrayList(component.getRequiredIntents());
            PolicyConfigurationUtil.trimInherentlyProvidedIntents(policiedImplementation.getType(), component.getRequiredIntents());
            PolicyConfigurationUtil.trimProvidedIntents((List<Intent>)component.getRequiredIntents(), component.getPolicySets());
            if (component.getRequiredIntents().size() > 0) {
                throw new PolicyConfigurationException("The following are unfulfilled intents for component implementation - " + component.getName() + "\nUnfulfilled Intents = " + component.getRequiredIntents());
            }
            component.getRequiredIntents().clear();
            component.getRequiredIntents().addAll(intentsCopy);
        }
    }
}

