/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ServiceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeServicePromotionBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public CompositeServicePromotionBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeServicePromotionBuilder";
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            ComponentService promotedService = ServiceConfigurationUtil.getPromotedComponentService(compositeService);
            if (promotedService == null) continue;
            Component promotedComponent = ServiceConfigurationUtil.getPromotedComponent(compositeService);
            ComponentService newComponentService = this.assemblyFactory.createComponentService();
            newComponentService.setName("$promoted$" + compositeService.getName());
            promotedComponent.getServices().add(newComponentService);
            newComponentService.setService(promotedService.getService());
            newComponentService.getBindings().addAll(compositeService.getBindings());
            newComponentService.setInterfaceContract(compositeService.getInterfaceContract());
            if (compositeService.getInterfaceContract() != null && compositeService.getInterfaceContract().getCallbackInterface() != null) {
                newComponentService.setCallback(this.assemblyFactory.createCallback());
                newComponentService.getCallback().getBindings().addAll(compositeService.getCallback().getBindings());
            }
            compositeService.setPromotedComponent(promotedComponent);
            compositeService.setPromotedService(newComponentService);
        }
    }
}

