/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.AutomaticBinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeServiceConfigurationBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public CompositeServiceConfigurationBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeServiceConfigurationBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.configureNestedCompositeServices(composite);
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            ComponentService promotedService = compositeService.getPromotedService();
            if (promotedService == null) continue;
            if (!this.bindingsSpecifiedManually(compositeService.getBindings()) && this.bindingsSpecifiedManually(promotedService.getBindings())) {
                compositeService.getBindings().clear();
                for (Binding binding : promotedService.getBindings()) {
                    try {
                        compositeService.getBindings().add((Binding)binding.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            if (compositeService.getInterfaceContract() == null || compositeService.getInterfaceContract().getCallbackInterface() == null || compositeService.getCallback() != null && this.bindingsSpecifiedManually(compositeService.getCallback().getBindings()) || promotedService.getCallback() == null || !this.bindingsSpecifiedManually(promotedService.getCallback().getBindings())) continue;
            if (compositeService.getCallback() != null) {
                compositeService.getCallback().getBindings().clear();
            } else {
                compositeService.setCallback(this.assemblyFactory.createCallback());
            }
            for (Binding binding : promotedService.getCallback().getBindings()) {
                try {
                    compositeService.getCallback().getBindings().add((Binding)binding.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
        }
    }

    private void configureNestedCompositeServices(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureNestedCompositeServices((Composite)implementation);
            for (ComponentService componentService : component.getServices()) {
                CompositeService compositeService;
                ComponentService promotedService;
                Service implService = componentService.getService();
                if (implService == null || !(implService instanceof CompositeService) || (promotedService = (compositeService = (CompositeService)implService).getPromotedService()) == null) continue;
                if (!this.bindingsSpecifiedManually(compositeService.getBindings()) && this.bindingsSpecifiedManually(promotedService.getBindings())) {
                    compositeService.getBindings().clear();
                    for (Binding binding : promotedService.getBindings()) {
                        try {
                            compositeService.getBindings().add((Binding)binding.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                if (!this.bindingsSpecifiedManually(componentService.getBindings()) && this.bindingsSpecifiedManually(compositeService.getBindings())) {
                    componentService.getBindings().clear();
                    componentService.getBindings().addAll(compositeService.getBindings());
                }
                if (componentService.getInterfaceContract() == null || componentService.getInterfaceContract().getCallbackInterface() == null) continue;
                if ((compositeService.getCallback() == null || !this.bindingsSpecifiedManually(compositeService.getCallback().getBindings())) && promotedService.getCallback() != null && this.bindingsSpecifiedManually(promotedService.getCallback().getBindings())) {
                    if (compositeService.getCallback() != null) {
                        compositeService.getCallback().getBindings().clear();
                    } else {
                        compositeService.setCallback(this.assemblyFactory.createCallback());
                    }
                    for (Binding binding : promotedService.getCallback().getBindings()) {
                        try {
                            compositeService.getCallback().getBindings().add((Binding)binding.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                if (componentService.getCallback() != null && this.bindingsSpecifiedManually(componentService.getCallback().getBindings()) || compositeService.getCallback() == null || !this.bindingsSpecifiedManually(compositeService.getCallback().getBindings())) continue;
                if (componentService.getCallback() != null) {
                    componentService.getCallback().getBindings().clear();
                } else {
                    componentService.setCallback(this.assemblyFactory.createCallback());
                }
                componentService.getCallback().getBindings().addAll(compositeService.getCallback().getBindings());
            }
        }
    }

    private boolean bindingsSpecifiedManually(List<Binding> bindings) {
        if (bindings.size() > 1) {
            return true;
        }
        if (bindings.size() == 1 && bindings.get(0) instanceof AutomaticBinding && ((AutomaticBinding)((Object)bindings.get(0))).getIsAutomatic()) {
            return false;
        }
        return bindings.size() == 1;
    }
}

