/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BindingBuilderExtension;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ServiceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeServiceBindingBuilderImpl
implements CompositeBuilder {
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeServiceBindingBuilder";
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.buildServiceBindings(composite, monitor);
    }

    private void buildServiceBindings(Composite composite, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.buildServiceBindings((Composite)implementation, monitor);
        }
        for (Service service : composite.getServices()) {
            for (Binding binding : service.getBindings()) {
                if (!(binding instanceof BindingBuilderExtension)) continue;
                Component component = ServiceConfigurationUtil.getPromotedComponent((CompositeService)service);
                ((BindingBuilderExtension)((Object)binding)).getBuilder().build(component, service, binding, monitor);
            }
        }
    }
}

