/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.AutomaticBinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.PolicySubject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBuilderImpl
implements CompositeBuilder {
    protected static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200903";
    protected static final String BINDING_SCA = "binding.sca";
    protected static final QName BINDING_SCA_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "binding.sca");
    protected AssemblyFactory assemblyFactory;
    protected SCABindingFactory scaBindingFactory;
    protected InterfaceContractMapper interfaceContractMapper;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;

    protected BaseBuilderImpl(AssemblyFactory assemblyFactory, SCABindingFactory scaBindingFactory, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, InterfaceContractMapper interfaceContractMapper) {
        this.assemblyFactory = assemblyFactory;
        this.scaBindingFactory = scaBindingFactory;
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
        this.interfaceContractMapper = interfaceContractMapper;
    }

    protected void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = null;
            problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    protected void indexComponents(Composite composite, Map<String, Component> components) {
        for (Component component : composite.getComponents()) {
            components.put(component.getName(), component);
        }
    }

    protected void indexServices(Composite composite, Map<String, ComponentService> componentServices) {
        for (Component component : composite.getComponents()) {
            ComponentService nonCallbackService = null;
            int nonCallbackServiceCount = 0;
            for (ComponentService componentService : component.getServices()) {
                String uri = String.valueOf(component.getName()) + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                if (componentService.isCallback()) continue;
                if (nonCallbackServiceCount == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServiceCount;
            }
            if (nonCallbackServiceCount != true) continue;
            componentServices.put(component.getName(), nonCallbackService);
        }
    }

    protected void indexComponentsServicesAndReferences(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        for (Component component : composite.getComponents()) {
            String uri;
            components.put(component.getName(), component);
            ComponentService nonCallbackService = null;
            int nonCallbackServices = 0;
            for (ComponentService componentService : component.getServices()) {
                uri = String.valueOf(component.getName()) + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                boolean promotedService = false;
                if (componentService.getName() != null && componentService.getName().indexOf("$promoted$") > -1) {
                    promotedService = true;
                }
                if (componentService.isCallback() || promotedService) continue;
                if (nonCallbackServices == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServices;
            }
            if (nonCallbackServices == 1) {
                componentServices.put(component.getName(), nonCallbackService);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                uri = String.valueOf(component.getName()) + '/' + componentReference.getName();
                componentReferences.put(uri, componentReference);
            }
        }
    }

    protected void indexComponentPropertiesServicesAndReferences(Component component, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences, Map<String, ComponentProperty> componentProperties, Monitor monitor) {
        for (ComponentService componentService : component.getServices()) {
            if (componentServices.containsKey(componentService.getName())) {
                this.warning(monitor, "DuplicateComponentServiceName", component, component.getName(), componentService.getName());
                continue;
            }
            componentServices.put(componentService.getName(), componentService);
        }
        for (ComponentReference componentReference : component.getReferences()) {
            if (componentReferences.containsKey(componentReference.getName())) {
                this.warning(monitor, "DuplicateComponentReferenceName", component, component.getName(), componentReference.getName());
                continue;
            }
            componentReferences.put(componentReference.getName(), componentReference);
        }
        for (ComponentProperty componentProperty : component.getProperties()) {
            if (componentProperties.containsKey(componentProperty.getName())) {
                this.warning(monitor, "DuplicateComponentPropertyName", component, component.getName(), componentProperty.getName());
                continue;
            }
            componentProperties.put(componentProperty.getName(), componentProperty);
        }
    }

    protected void indexImplementationPropertiesServicesAndReferences(Component component, Map<String, Service> services, Map<String, Reference> references, Map<String, Property> properties, Monitor monitor) {
        Implementation implementation = component.getImplementation();
        if (implementation == null) {
            this.warning(monitor, "NoComponentImplementation", component, component.getName());
        } else if (implementation.isUnresolved()) {
            this.warning(monitor, "UnresolvedComponentImplementation", component, component.getName(), implementation.getURI());
        } else {
            for (Property property : implementation.getProperties()) {
                if (properties.containsKey(property.getName())) {
                    this.warning(monitor, "DuplicateImplementationPropertyName", component, component.getName(), property.getName());
                    continue;
                }
                properties.put(property.getName(), property);
            }
            for (Service service : implementation.getServices()) {
                if (services.containsKey(service.getName())) {
                    this.warning(monitor, "DuplicateImplementationServiceName", component, component.getName(), service.getName());
                    continue;
                }
                services.put(service.getName(), service);
            }
            for (Reference reference : implementation.getReferences()) {
                if (references.containsKey(reference.getName())) {
                    this.warning(monitor, "DuplicateImplementationReferenceName", component, component.getName(), reference.getName());
                    continue;
                }
                references.put(reference.getName(), reference);
            }
        }
    }

    protected void reconcileProperties(Component component, Map<String, Property> properties, Map<String, ComponentProperty> componentProperties, Monitor monitor) {
        Property property;
        for (ComponentProperty componentProperty : component.getProperties()) {
            property = properties.get(componentProperty.getName());
            if (property != null) {
                componentProperty.setProperty(property);
                continue;
            }
            this.warning(monitor, "PropertyNotFound", component, component.getName(), componentProperty.getName());
        }
        if (component.getImplementation() != null) {
            for (Property property2 : component.getImplementation().getProperties()) {
                if (componentProperties.containsKey(property2.getName())) continue;
                ComponentProperty componentProperty = this.assemblyFactory.createComponentProperty();
                componentProperty.setName(property2.getName());
                componentProperty.setMany(property2.isMany());
                componentProperty.setXSDElement(property2.getXSDElement());
                componentProperty.setXSDType(property2.getXSDType());
                componentProperty.setProperty(property2);
                component.getProperties().add(componentProperty);
            }
        }
        for (ComponentProperty componentProperty : component.getProperties()) {
            property = componentProperty.getProperty();
            if (property == null) continue;
            if (!property.isMustSupply() && componentProperty.isMustSupply()) {
                this.warning(monitor, "PropertyMustSupplyIncompatible", component, component.getName(), componentProperty.getName());
            }
            if (!componentProperty.isMustSupply()) {
                componentProperty.setMustSupply(property.isMustSupply());
            }
            if (componentProperty.getValue() == null) {
                componentProperty.setValue(property.getValue());
            }
            if (component.getImplementation() instanceof Composite) {
                property.setValue(componentProperty.getValue());
            }
            if (componentProperty.getValue() == null && property.isMustSupply()) {
                this.warning(monitor, "PropertyMustSupplyNull", component, component.getName(), componentProperty.getName());
            }
            if (!property.isMany() && componentProperty.isMany()) {
                this.warning(monitor, "PropertyOverrideManyAttribute", component, component.getName(), componentProperty.getName());
            }
            componentProperty.setMany(property.isMany());
            if (componentProperty.getXSDType() == null) {
                componentProperty.setXSDType(property.getXSDType());
            }
            if (componentProperty.getXSDElement() == null) {
                componentProperty.setXSDElement(property.getXSDElement());
            }
            if (componentProperty.getXSDElement() != null || componentProperty.getXSDType() != null) continue;
            this.warning(monitor, "NoTypeForComponentProperty", component, component.getName(), componentProperty.getName());
        }
    }

    protected void reconcileReferences(Component component, Map<String, Reference> references, Map<String, ComponentReference> componentReferences, Monitor monitor) {
        Reference reference;
        for (ComponentReference componentReference : component.getReferences()) {
            if (componentReference.getReference() != null || componentReference.isCallback()) continue;
            reference = references.get(componentReference.getName());
            if (reference != null) {
                componentReference.setReference(reference);
                continue;
            }
            if (componentReference.getName().startsWith("$self$.")) continue;
            this.error(monitor, "ReferenceNotFound", (Object)component, component.getName(), componentReference.getName());
        }
        if (component.getImplementation() != null) {
            for (Reference reference2 : component.getImplementation().getReferences()) {
                if (componentReferences.containsKey(reference2.getName())) continue;
                ComponentReference componentReference = this.assemblyFactory.createComponentReference();
                componentReference.setIsCallback(reference2.isCallback());
                componentReference.setName(reference2.getName());
                componentReference.setReference(reference2);
                component.getReferences().add(componentReference);
            }
        }
        for (ComponentReference componentReference : component.getReferences()) {
            reference = componentReference.getReference();
            if (reference == null) continue;
            if (componentReference.getMultiplicity() != null) {
                if (!ReferenceConfigurationUtil.isValidMultiplicityOverride(reference.getMultiplicity(), componentReference.getMultiplicity())) {
                    this.warning(monitor, "ReferenceIncompatibleMultiplicity", component, component.getName(), componentReference.getName());
                }
            } else {
                componentReference.setMultiplicity(reference.getMultiplicity());
            }
            InterfaceContract interfaceContract = reference.getInterfaceContract();
            if (componentReference.getInterfaceContract() != null) {
                if (interfaceContract != null && !componentReference.getInterfaceContract().equals(reference.getInterfaceContract()) && !this.interfaceContractMapper.isCompatible(componentReference.getInterfaceContract(), interfaceContract)) {
                    this.warning(monitor, "ReferenceIncompatibleComponentInterface", component, component.getName(), componentReference.getName());
                }
            } else {
                componentReference.setInterfaceContract(interfaceContract);
            }
            if (componentReference.getBindings().isEmpty()) {
                componentReference.getBindings().addAll(reference.getBindings());
            }
            if (componentReference.getCallback() == null) {
                componentReference.setCallback(reference.getCallback());
                if (componentReference.getCallback() == null) {
                    componentReference.setCallback(this.assemblyFactory.createCallback());
                }
            } else if (componentReference.getCallback().getBindings().isEmpty() && reference.getCallback() != null) {
                componentReference.getCallback().getBindings().addAll(reference.getCallback().getBindings());
            }
            if (componentReference.getAutowire() == null) {
                componentReference.setAutowire(component.getAutowire());
            }
            if (!componentReference.getTargets().isEmpty()) continue;
            componentReference.getTargets().addAll(reference.getTargets());
        }
    }

    protected void reconcileServices(Component component, Map<String, Service> services, Map<String, ComponentService> componentServices, Monitor monitor) {
        Service service;
        for (ComponentService componentService : component.getServices()) {
            if (componentService.getService() != null || componentService.isCallback()) continue;
            service = services.get(componentService.getName());
            if (service != null) {
                componentService.setService(service);
                continue;
            }
            this.warning(monitor, "ServiceNotFoundForComponentService", component, component.getName(), componentService.getName());
        }
        if (component.getImplementation() != null) {
            for (Service service2 : component.getImplementation().getServices()) {
                if (componentServices.containsKey(service2.getName())) continue;
                ComponentService componentService = this.assemblyFactory.createComponentService();
                componentService.setIsCallback(service2.isCallback());
                String name = service2.getName();
                componentService.setName(name);
                componentService.setService(service2);
                component.getServices().add(componentService);
                componentServices.put(name, componentService);
            }
        }
        for (ComponentService componentService : component.getServices()) {
            service = componentService.getService();
            if (service == null) continue;
            InterfaceContract interfaceContract = service.getInterfaceContract();
            if (componentService.getInterfaceContract() != null) {
                if (interfaceContract != null && !componentService.getInterfaceContract().equals(interfaceContract) && !this.interfaceContractMapper.isCompatible(componentService.getInterfaceContract(), interfaceContract)) {
                    this.warning(monitor, "ServiceIncompatibleComponentInterface", component, component.getName(), componentService.getName());
                }
            } else {
                componentService.setInterfaceContract(interfaceContract);
            }
            if (componentService.getBindings().isEmpty()) {
                componentService.getBindings().addAll(service.getBindings());
            }
            if (componentService.getCallback() == null) {
                componentService.setCallback(service.getCallback());
                if (componentService.getCallback() != null) continue;
                componentService.setCallback(this.assemblyFactory.createCallback());
                continue;
            }
            if (!componentService.getCallback().getBindings().isEmpty() || service.getCallback() == null) continue;
            componentService.getCallback().getBindings().addAll(service.getCallback().getBindings());
        }
    }

    protected SCABinding createSCABinding(Definitions definitions) {
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        if (scaBinding instanceof AutomaticBinding) {
            ((AutomaticBinding)((Object)scaBinding)).setIsAutomatic(true);
        }
        if (definitions != null) {
            for (ExtensionType attachPointType : definitions.getBindingTypes()) {
                if (!attachPointType.getType().equals(BINDING_SCA_QNAME)) continue;
                ((PolicySubject)scaBinding).setType(attachPointType);
            }
        }
        return scaBinding;
    }
}

