/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

public class DefaultCompositeBuilderExtensionPoint
implements CompositeBuilderExtensionPoint {
    private ExtensionPointRegistry registry;
    private final Map<String, CompositeBuilder> builders = new HashMap<String, CompositeBuilder>();
    private boolean loaded;

    public DefaultCompositeBuilderExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    public void addCompositeBuilder(CompositeBuilder builder) {
        this.builders.put(builder.getID(), builder);
    }

    public void removeCompositeBuilder(CompositeBuilder builder) {
        this.builders.remove(builder.getID());
    }

    public CompositeBuilder getCompositeBuilder(String id) {
        this.loadBuilders();
        return this.builders.get(id);
    }

    private synchronized void loadBuilders() {
        Set builderDeclarations;
        if (this.loaded) {
            return;
        }
        FactoryExtensionPoint factories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        UtilityExtensionPoint utils = (UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        InterfaceContractMapper mapper = (InterfaceContractMapper)utils.getUtility(InterfaceContractMapper.class);
        ServiceDiscovery serviceDiscovery = ServiceDiscovery.getInstance();
        try {
            builderDeclarations = serviceDiscovery.getServiceDeclarations(CompositeBuilder.class.getName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration builderDeclaration : builderDeclarations) {
            Map attributes = builderDeclaration.getAttributes();
            String id = (String)attributes.get("id");
            LazyCompositeBuilder builder = new LazyCompositeBuilder(id, builderDeclaration, this, factories, mapper);
            this.builders.put(id, builder);
        }
    }

    private static class LazyCompositeBuilder
    implements CompositeBuilder {
        private FactoryExtensionPoint factories;
        private InterfaceContractMapper mapper;
        private String id;
        private ServiceDeclaration builderDeclaration;
        private CompositeBuilder builder;
        private CompositeBuilderExtensionPoint builders;

        private LazyCompositeBuilder(String id, ServiceDeclaration factoryDeclaration, CompositeBuilderExtensionPoint builders, FactoryExtensionPoint factories, InterfaceContractMapper mapper) {
            this.id = id;
            this.builderDeclaration = factoryDeclaration;
            this.builders = builders;
            this.factories = factories;
            this.mapper = mapper;
        }

        public String getID() {
            return this.id;
        }

        public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
            this.getBuilder().build(composite, definitions, monitor);
        }

        private CompositeBuilder getBuilder() {
            if (this.builder == null) {
                try {
                    Class builderClass = this.builderDeclaration.loadClass();
                    try {
                        Constructor constructor = builderClass.getConstructor(FactoryExtensionPoint.class, InterfaceContractMapper.class);
                        this.builder = (CompositeBuilder)constructor.newInstance(this.factories, this.mapper);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Constructor constructor = builderClass.getConstructor(CompositeBuilderExtensionPoint.class, FactoryExtensionPoint.class, InterfaceContractMapper.class);
                        this.builder = (CompositeBuilder)constructor.newInstance(this.builders, this.factories, this.mapper);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.builder;
        }
    }
}

