/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BindingBuilderExtension;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.monitor.Monitor;

public class ComponentServiceBindingBuilderImpl
implements CompositeBuilder {
    private Monitor monitor;

    public ComponentServiceBindingBuilderImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    public void build(Composite composite) throws CompositeBuilderException {
        this.buildServiceBindings(composite);
    }

    private void buildServiceBindings(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.buildServiceBindings((Composite)implementation);
        }
        for (Component component : composite.getComponents()) {
            for (ComponentService componentService : component.getServices()) {
                for (Binding binding : componentService.getBindings()) {
                    BindingBuilder builder;
                    if (!(binding instanceof BindingBuilderExtension) || (builder = ((BindingBuilderExtension)((Object)binding)).getBuilder()) == null) continue;
                    builder.build(component, componentService, binding, this.monitor);
                }
            }
        }
    }
}

