/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.EndpointFactory;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.assembly.builder.impl.ServiceConfigurationUtil;
import org.apache.tuscany.sca.monitor.Monitor;

public class ComponentReferencePromotionWireBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;
    private EndpointFactory endpointFactory;
    private Monitor monitor;

    public ComponentReferencePromotionWireBuilderImpl(AssemblyFactory assemblyFactory, EndpointFactory endpointFactory, Monitor monitor) {
        this.assemblyFactory = assemblyFactory;
        this.endpointFactory = endpointFactory;
        this.monitor = monitor;
    }

    public void build(Composite composite) throws CompositeBuilderException {
        this.wireCompositeReferences(composite);
    }

    private void wireCompositeReferences(Composite composite) {
        Implementation implementation;
        for (Component component : composite.getComponents()) {
            implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.wireCompositeReferences((Composite)implementation);
        }
        for (Component component : composite.getComponents()) {
            implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                for (ComponentReference componentReference : component.getReferences()) {
                    Reference implReference = componentReference.getReference();
                    if (implReference == null || !(implReference instanceof CompositeReference)) continue;
                    if (!componentReference.getEndpoints().isEmpty()) {
                        componentReference.setPromotionOverride(true);
                    }
                    if (!componentReference.isPromotionOverride()) continue;
                    CompositeReference compositeReference = (CompositeReference)implReference;
                    List<ComponentReference> promotedReferences = ReferenceConfigurationUtil.getPromotedComponentReferences(compositeReference);
                    for (ComponentReference promotedReference : promotedReferences) {
                        ReferenceConfigurationUtil.reconcileReferenceBindings(componentReference, promotedReference, this.assemblyFactory, this.endpointFactory, this.monitor);
                        if (componentReference.getInterfaceContract() != null && componentReference.getInterfaceContract().getCallbackInterface() != null) {
                            SCABinding scaCallbackBinding = (SCABinding)promotedReference.getCallbackBinding(SCABinding.class);
                            if (promotedReference.getCallback() != null) {
                                promotedReference.getCallback().getBindings().clear();
                            } else {
                                promotedReference.setCallback(this.assemblyFactory.createCallback());
                            }
                            if (scaCallbackBinding != null) {
                                promotedReference.getCallback().getBindings().add(scaCallbackBinding);
                            }
                            if (componentReference.getCallback() != null) {
                                promotedReference.getCallback().getBindings().addAll(componentReference.getCallback().getBindings());
                            }
                        }
                        if (promotedReference.getMultiplicity() == Multiplicity.ONE_ONE) {
                            // empty if block
                        }
                        for (ComponentService target : componentReference.getTargets()) {
                            if (target.getService() instanceof CompositeService) {
                                CompositeService compositeService = (CompositeService)target.getService();
                                ComponentService componentService = ServiceConfigurationUtil.getPromotedComponentService(compositeService);
                                if (componentService == null) continue;
                                promotedReference.getTargets().add(componentService);
                                continue;
                            }
                            promotedReference.getTargets().add(target);
                        }
                    }
                }
                continue;
            }
            for (ComponentReference componentReference : component.getReferences()) {
                List<ComponentService> targets = componentReference.getTargets();
                int n = targets.size();
                for (int i = 0; i < n; ++i) {
                    CompositeService compositeService;
                    ComponentService componentService;
                    ComponentService target = targets.get(i);
                    if (!(target.getService() instanceof CompositeService) || (componentService = (compositeService = (CompositeService)target.getService()).getPromotedService()) == null) continue;
                    targets.set(i, componentService);
                }
            }
        }
    }
}

