/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySubject;

public class SCABindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<SCABinding> {
    private static final String NAME = "name";
    private static final String URI = "uri";
    private static final String DELEGATE_BINDING_TYPE = "delegateBindingType";
    private static final String DELEGATE_BINDING_URI = "delegateBindingURI";
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final String BINDING_SCA = "binding.sca";
    private static final QName BINDING_SCA_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.sca");
    private PolicyFactory policyFactory;
    private SCABindingFactory scaBindingFactory;
    private PolicySubjectProcessor policyProcessor;
    private PolicyFactory intentAttachPointTypeFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;

    public SCABindingProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor) {
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.scaBindingFactory = (SCABindingFactory)modelFactories.getFactory(SCABindingFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
        this.intentAttachPointTypeFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.extensionProcessor = extensionProcessor;
    }

    public QName getArtifactType() {
        return BINDING_SCA_QNAME;
    }

    public Class<SCABinding> getModelType() {
        return SCABinding.class;
    }

    public SCABinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String delegateBindingURI;
        String delegateBindingType;
        String uri;
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        BindingType bindingType = this.intentAttachPointTypeFactory.createBindingType();
        bindingType.setType(this.getArtifactType());
        bindingType.setUnresolved(true);
        ((PolicySubject)scaBinding).setExtensionType((ExtensionType)bindingType);
        this.policyProcessor.readPolicies(scaBinding, reader);
        String name = reader.getAttributeValue(null, NAME);
        if (name != null) {
            scaBinding.setName(name);
        }
        if ((uri = this.getURIString(reader, URI)) != null) {
            scaBinding.setURI(uri);
        }
        if ((delegateBindingType = this.getString(reader, DELEGATE_BINDING_TYPE)) != null) {
            scaBinding.setDelegateBindingType(delegateBindingType);
        }
        if ((delegateBindingURI = this.getURIString(reader, DELEGATE_BINDING_URI)) != null) {
            scaBinding.setDelegateBindingURI(delegateBindingURI);
        }
        boolean endFound = false;
        while (reader.hasNext() && !endFound) {
            int nextElementType = reader.next();
            switch (nextElementType) {
                case 1: {
                    Object extension = this.extensionProcessor.read(reader, context);
                    if (extension == null || !(extension instanceof WireFormat)) break;
                    scaBinding.setRequestWireFormat((WireFormat)extension);
                    break;
                }
                case 2: {
                    QName endElementName = reader.getName();
                    if (!endElementName.equals(endElementName)) break;
                    endFound = true;
                }
            }
        }
        return scaBinding;
    }

    public void resolve(SCABinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.policyProcessor.resolvePolicies(model, resolver, context);
    }

    public void write(SCABinding scaBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(SCA11_NS, BINDING_SCA);
        this.policyProcessor.writePolicyAttributes(scaBinding, writer);
        if (scaBinding.getName() != null) {
            writer.writeAttribute(NAME, scaBinding.getName());
        }
        if (scaBinding.getURI() != null) {
            writer.writeAttribute(URI, scaBinding.getURI());
        }
        if (scaBinding.getDelegateBindingType() != null) {
            writer.writeAttribute(DELEGATE_BINDING_TYPE, scaBinding.getDelegateBindingType());
        }
        if (scaBinding.getDelegateBindingURI() != null) {
            writer.writeAttribute(DELEGATE_BINDING_URI, scaBinding.getDelegateBindingURI());
        }
        this.extensionProcessor.write((Object)scaBinding.getRequestWireFormat(), writer, context);
        writer.writeEndElement();
    }
}

